package com.supwisdom.dlpay.visitormanage.dao.impl;

import com.supwisdom.dlpay.customer.bean.CustomerSearchBean;
import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.mainservice.dao.CustomerDao;
import com.supwisdom.dlpay.mainservice.domain.TCustomer;
import com.supwisdom.dlpay.system.domain.TRegion;
import com.supwisdom.dlpay.visitormanage.dao.VisitorDao;
import com.supwisdom.dlpay.visitormanage.domain.*;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.math.BigInteger;
import java.util.List;

@Repository
public class VisitorDaoImpl implements VisitorDao {

    @PersistenceContext
    EntityManager entityManager;



    @Transactional
    @Override
    public PageResult<EVisitorDtl> getVisitorInfoPage(VisitorSearchBean param) {

        String nickname = param.getNickname();
        String inoutflag = param.getInoutflag();
        String startdate = param.getStartdate();
        String enddate = param.getEnddate();
        String sql = "select a.id,a.openid,a.status,a.nickname,a.sex,a.province,a.city,a.country,a.inoutflag,a.transdate,a.transtime from E_VISITOR_DTL a  " +
                " where a.status='1'   ";
        String countSql = "select count(*) as cnt from E_VISITOR_DTL a  " +
                " where a.status='1' ";

        if (!StringUtil.isEmpty(nickname)){
            sql += " and a.nickname like :nickname ";
            countSql += " and a.nickname like :nickname ";
        }if (!StringUtil.isEmpty(inoutflag)){
            sql += " and a.inoutflag = :inoutflag ";
            countSql += " and a.inoutflag = :inoutflag ";
        }if (!StringUtil.isEmpty(startdate)){
            sql += " and a.transdate >= :startdate ";
            countSql += " and a.transdate >= :startdate ";
        }if (!StringUtil.isEmpty(enddate)){
            sql += " and a.transdate <= :enddate ";
            countSql += " and a.transdate <= :enddate ";
        }
        sql +=" order by a.transtime desc ";


        Query query = entityManager.createNativeQuery(sql);
        Query countQuery = entityManager.createNativeQuery(countSql);
        if (!StringUtil.isEmpty(nickname)){
            query.setParameter("nickname", "%"+nickname+"%");
            countQuery.setParameter("nickname", "%"+nickname+"%");
        }if (!StringUtil.isEmpty(inoutflag)){
            query.setParameter("inoutflag", Integer.parseInt(inoutflag));
            countQuery.setParameter("inoutflag", Integer.parseInt(inoutflag));
        }if (!StringUtil.isEmpty(startdate)){
            query.setParameter("startdate", startdate);
            countQuery.setParameter("startdate", startdate);
        }if (!StringUtil.isEmpty(enddate)){
            query.setParameter("enddate", enddate);
            countQuery.setParameter("enddate", enddate);
        }
        query.setFirstResult((param.getPageNo() - 1) * param.getPageSize());
        query.setMaxResults(param.getPageSize()); //分页显示

        query.unwrap(NativeQueryImpl.class).setResultTransformer(Transformers.aliasToBean(EVisitorDtl.class));
        List<EVisitorDtl> list = query.getResultList();
        BigInteger count = (BigInteger) countQuery.getSingleResult();
        return new PageResult<>(count.longValue(), list);
    }
    @Transactional
    @Override
    public PageResult<VisitorShowBean> getCheckInfoPage(VisitorCheckSearchBean param) {

        String visitorname = param.getVisitorname();
        String sex = param.getSex();
        String startdate = param.getStartdate();
        String enddate = param.getEnddate();
        String sql = "select a.visitorname,a.idno,a.phone,a.transdate,a.transtime,a.deptcode,a.custid,a.company,a.sex,a.remarks,b.custname,c.deptname from E_VISITOR_CHECK_DTL a left join t_customer b on a.custid=b.custid left join tb_dept c on c.deptcode=a.deptcode " +
                " where a.status='1'   ";
        String countSql = "select count(*) as cnt  from E_VISITOR_CHECK_DTL a left join t_customer b on a.custid=b.custid left join tb_dept c on c.deptcode=a.deptcode  " +
                " where a.status='1' ";

        if (!StringUtil.isEmpty(visitorname)){
            sql += " and a.visitorname like :visitorname ";
            countSql += " and a.visitorname like :visitorname ";
        }if (!StringUtil.isEmpty(sex)){
            sql += " and a.sex = :sex ";
            countSql += " and a.sex = :sex ";
        }if (!StringUtil.isEmpty(startdate)){
            sql += " and a.transdate >= :startdate ";
            countSql += " and a.transdate >= :startdate ";
        }if (!StringUtil.isEmpty(enddate)){
            sql += " and a.transdate <= :enddate ";
            countSql += " and a.transdate <= :enddate ";
        }
        sql +=" order by a.transtime desc ";


        Query query = entityManager.createNativeQuery(sql);
        Query countQuery = entityManager.createNativeQuery(countSql);
        if (!StringUtil.isEmpty(visitorname)){
            query.setParameter("visitorname", "%"+visitorname+"%");
            countQuery.setParameter("visitorname", "%"+visitorname+"%");
        }if (!StringUtil.isEmpty(sex)){
            query.setParameter("sex", sex);
            countQuery.setParameter("sex", sex);
        }if (!StringUtil.isEmpty(startdate)){
            query.setParameter("startdate", startdate);
            countQuery.setParameter("startdate", startdate);
        }if (!StringUtil.isEmpty(enddate)){
            query.setParameter("enddate", enddate);
            countQuery.setParameter("enddate", enddate);
        }
        query.setFirstResult((param.getPageNo() - 1) * param.getPageSize());
        query.setMaxResults(param.getPageSize()); //分页显示

        query.unwrap(NativeQueryImpl.class).setResultTransformer(Transformers.aliasToBean(VisitorShowBean.class));
        List<VisitorShowBean> list = query.getResultList();
        BigInteger count = (BigInteger) countQuery.getSingleResult();
        return new PageResult<>(count.longValue(), list);
    }
    @Transactional
    @Override
    public boolean saveVisitorCheck(EVisitorCheckDtl bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

}
