package com.supwisdom.dlpay.api.domain;

import javax.persistence.*;

@Entity
@Table(name = "TB_PERSONDTL",
    indexes = {@Index(name = "prsndtl_transdate_idx", columnList = "transdate"),
        @Index(name = "prsndtl_accdate_idx", columnList = "accdate"),
        @Index(name = "prsndtl_status_idx", columnList = "status"),
        @Index(name = "prsndtl_reverse_idx", columnList = "REVERSE_FLAG")})
public class TPersondtl {

  @Id
  @Column(name = "REFNO", nullable = false, length = 32)
  private String refno; //流水号

  @Column(name = "ACCDATE", length = 8, nullable = false)
  private String accdate; //记账日期

  @Column(name = "USERID", length = 32, nullable = false)
  private String userid;  //用户ID，或账号

  @Column(name = "acccno", length = 32)
  private String accountNo;

  @Column(name = "USERNAME", length = 200)
  private String userName;

  @Column(name = "TRANSDATE", length = 8, nullable = false)
  private String transdate;

  @Column(name = "TRANSTIME", length = 6, nullable = false)
  private String transtime;

  @Column(name = "STATUS", length = 20, nullable = false)
  private String status;

  @Column(name = "BEFBAL", precision = 9, scale = 2)
  private Double befbal;

  @Column(name = "amount", precision = 9, scale = 2, nullable = false)
  private Double amount; //实际付款金额

  @Column(name = "PAYTYPE", length = 20)
  private String paytype; //支付方式 balance,wechat,alipay

  @Column(name = "PAYINFO", length = 200)
  private String payinfo; //记录支付信息备用字段

  @Column(name = "TRANSCODE", precision = 4, nullable = false)
  private Integer transcode;

  @Column(name = "TRANSDESC", length = 240)
  private String transdesc; //交易描述

  @Column(name = "OUTTRADENO", length = 60)
  private String outtradeno; //第三方流水号

  @Column(name = "OPPOSITEACCNO", length = 20)
  private String oppositeAccNo;

  @Column(name = "OPPOSITEACCNAME", length = 200)
  private String oppositeAccName;

  @Column(name = "OPERID", precision = 9)
  private Integer operid; //操作员ID

  @Column(name = "REVERSE_FLAG", nullable = false, length = 10)
  private String reverseFlag = "none"; //none, cancel, reversed

  @Column(name = "REVERSE_AMOUNT", precision = 9, scale = 2)
  private Double reverseAmount = 0D; //撤销金额填写

  @Column(name = "TRADEFLAG", nullable = false, length = 10)
  private String tradeflag; //deposit-充值；pay-消费

  @Column(name = "REMARK", length = 240)
  private String remark;

  public String getRefno() {
    return refno;
  }

  public void setRefno(String refno) {
    this.refno = refno;
  }

  public String getAccdate() {
    return accdate;
  }

  public void setAccdate(String accdate) {
    this.accdate = accdate;
  }

  public String getUserid() {
    return userid;
  }

  public void setUserid(String userid) {
    this.userid = userid;
  }

  public String getTransdate() {
    return transdate;
  }

  public void setTransdate(String transdate) {
    this.transdate = transdate;
  }

  public String getTranstime() {
    return transtime;
  }

  public void setTranstime(String transtime) {
    this.transtime = transtime;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public Double getBefbal() {
    return befbal;
  }

  public void setBefbal(Double befbal) {
    this.befbal = befbal;
  }

  public Double getAmount() {
    return amount;
  }

  public void setAmount(Double amount) {
    this.amount = amount;
  }

  public String getPaytype() {
    return paytype;
  }

  public void setPaytype(String paytype) {
    this.paytype = paytype;
  }

  public String getPayinfo() {
    return payinfo;
  }

  public void setPayinfo(String payinfo) {
    this.payinfo = payinfo;
  }

  public Integer getTranscode() {
    return transcode;
  }

  public void setTranscode(Integer transcode) {
    this.transcode = transcode;
  }

  public String getTransdesc() {
    return transdesc;
  }

  public void setTransdesc(String transdesc) {
    this.transdesc = transdesc;
  }

  public String getOuttradeno() {
    return outtradeno;
  }

  public void setOuttradeno(String outtradeno) {
    this.outtradeno = outtradeno;
  }

  public String getOppositeAccNo() {
    return oppositeAccNo;
  }

  public void setOppositeAccNo(String oppositeAccNo) {
    this.oppositeAccNo = oppositeAccNo;
  }

  public Integer getOperid() {
    return operid;
  }

  public void setOperid(Integer operid) {
    this.operid = operid;
  }

  public String getReverseFlag() {
    return reverseFlag;
  }

  public void setReverseFlag(String reverseFlag) {
    this.reverseFlag = reverseFlag;
  }

  public Double getReverseAmount() {
    return reverseAmount;
  }

  public void setReverseAmount(Double reverseAmount) {
    this.reverseAmount = reverseAmount;
  }

  public String getTradeflag() {
    return tradeflag;
  }

  public void setTradeflag(String tradeflag) {
    this.tradeflag = tradeflag;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  public String getOppositeAccName() {
    return oppositeAccName;
  }

  public void setOppositeAccName(String oppositeAccName) {
    this.oppositeAccName = oppositeAccName;
  }

  public String getAccountNo() {
    return accountNo;
  }

  public void setAccountNo(String accountNo) {
    this.accountNo = accountNo;
  }
}
