package com.supwisdom.dlpay.framework.util;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
  /**
   * 判断字符串是否为空
   */
  public static boolean isEmpty(String str) {
    if (null == str || "".equals(str) || "".equals(str.trim())) {
      return true;
    }
    return false;
  }

  /**
   * 判断List是否为空
   */
  public static boolean isEmpty(List list) {
    if (null == list || list.size() <= 0) {
      return true;
    }
    return false;
  }

  public static boolean equalsIgnoreCase(String str1, String str2) {
    return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
  }

  public static boolean equals(String str1, String str2) {
    return str1 == null ? str2 == null : str1.equals(str2);
  }

  /**
   * 手机号验证
   *
   * @param str
   * @return
   */
  public static boolean isMobile(String str) {
    Pattern p = Pattern.compile("^1[0-9]{10}$"); // 验证手机号
    Matcher m = p.matcher(str);
    return m.matches();
  }

  /**
   * 邮箱格式验证
   */
  public static boolean isEmail(String email) {
    boolean ret = true;
    Pattern pattern = Pattern.compile("^([a-zA-Z0-9]+[_|\\.]?)*[a-zA-Z0-9]+@([a-zA-Z0-9]+[_|\\.]?)*[a-zA-Z0-9]+\\.[a-zA-Z]{2,3}$");
    final Matcher mat = pattern.matcher(email);
    if (!mat.find()) {
      ret = false;
    }
    return ret;
  }

  /**
   * 身份证格式验证
   *
   * @param str
   * @return
   */
  public static boolean isIdentity(String str) {
    // 中国公民身份证格式：长度为15或18位，最后一位可以为字母
    Pattern pattern = Pattern.compile("(\\d{14}[0-9a-zA-Z])|(\\d{17}[0-9a-zA-Z])");
    final Matcher m = pattern.matcher(str);
    return m.matches();
  }

  /**
   * 除去数组中的空值和签名参数
   *
   * @param sArray 签名参数组
   * @return 去掉空值与签名参数后的新签名参数组
   */
  public static Map<String, String> paraFilter(Map<String, String> sArray) {
    Map<String, String> result = new HashMap<String, String>();
    if (sArray == null || sArray.size() <= 0) {
      return result;
    }
    for (String key : sArray.keySet()) {
      String value = sArray.get(key);
      if (null == value || "".equals(value.trim()) || "null".equalsIgnoreCase(value.trim()) || key.equalsIgnoreCase("sign") || key.equalsIgnoreCase("sign_type")) {
        continue;
      }
      result.put(key, value);
    }
    return result;
  }

  /**
   * 把数组所有元素排序，并按照“参数=参数值”的模式用“&”字符拼接成字符串
   *
   * @param params 需要排序并参与字符拼接的参数组
   * @return 拼接后字符串
   */
  public static String createLinkString(Map<String, String> params) {

    List<String> keys = new ArrayList<String>(params.keySet());
    Collections.sort(keys);

    String prestr = "";

    for (int i = 0; i < keys.size(); i++) {
      String key = keys.get(i);
      String value = params.get(key);

      if (i == keys.size() - 1) {//拼接时，不包括最后一个&字符
        prestr = prestr + key + "=" + value;
      } else {
        prestr = prestr + key + "=" + value + "&";
      }
    }

    return prestr;
  }

  public static boolean isCharAndNum(String inputStr) {
    Pattern p = Pattern.compile("\\w+");
    Matcher m = p.matcher(inputStr);
    if (m.matches()) {
      // 除字母和数字外还包含其它字符
      return false;
    } else {
      return true;
    }
  }


}
