package com.supwisdom.dlpay.system.service;

import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.api.domain.TAccount;
import com.supwisdom.dlpay.api.domain.TPerson;
import com.supwisdom.dlpay.api.domain.TPersonIdentity;
import com.supwisdom.dlpay.api.domain.TPointsAccount;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.system.bean.PersonParamBean;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface UserDataService {
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
    PageResult<TPerson> getPersonsByKey(PersonParamBean param);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
    PageResult<TAccount> getAccountsByKey(PersonParamBean param);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
    PageResult<TPointsAccount> getPointsByKey(PersonParamBean param);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    JsonResult saveUser(TPerson person);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    JsonResult deleteUser(String userid);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    JsonResult closeAccount(String accno);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    JsonResult deletePoint(String userid);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
    List<TPersonIdentity> getPersonIdentity(String userid);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
    PageResult<TPointsAccount> getUserPointDTL(PersonParamBean param);
}
