package com.supwisdom.dlpay.api

import com.supwisdom.dlpay.framework.ResponseBodyBuilder
import com.supwisdom.dlpay.framework.util.TradeErrorCode
import org.aspectj.lang.JoinPoint
import org.aspectj.lang.annotation.Aspect
import org.aspectj.lang.annotation.Before
import org.aspectj.lang.annotation.Pointcut
import org.springframework.http.ResponseEntity
import org.springframework.stereotype.Component
import org.springframework.web.bind.annotation.ExceptionHandler
import org.springframework.web.bind.annotation.RestControllerAdvice


@RestControllerAdvice
class RestControllerAdvice {

    @ExceptionHandler
    fun handleException(ex: Exception): ResponseEntity<Any> {
        return ResponseEntity.ok().body(ResponseBodyBuilder.create()
                .exception(TradeErrorCode.BUSINESS_DEAL_ERROR, ex.cause))
    }
}

@Component
@Aspect
class RestControllerAspect {

    @Pointcut("execution( * com.supwisdom.dlpay.api..*(..))")
    private fun beforeRequest() {
    }

    @Before("beforeRequest()")
    fun check(point: JoinPoint) {
        point.args.forEach {
            println("request : $it")
        }
    }
}
