package com.supwisdom.dlpay.framework.core;

import com.supwisdom.dlpay.framework.domain.TSettleLog;
import com.supwisdom.dlpay.framework.domain.TTaskLock;
import com.supwisdom.dlpay.framework.service.DayendSettleService;
import com.supwisdom.dlpay.framework.service.SystemUtilService;
import com.supwisdom.dlpay.framework.util.StringUtil;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class DayendSettleTask {
  @Autowired
  private SystemUtilService systemUtilService;
  @Autowired
  private DayendSettleService dayendSettleService;

  private TSettleLog settleLog;

  private static final Logger logger = Logger.getLogger(DayendSettleTask.class);


  public void doSettleTask() {
    if (logger.isDebugEnabled()) logger.debug("进入日结算任务！");

    TTaskLock lock = null;
    try {
      try {
        lock = systemUtilService.doLockTask("DAYENDSETTLETASK", 30, "日终结算");
        if (lock == null) {
          if (logger.isDebugEnabled()) logger.debug("日终结算正在其他服务器上执行");
          return;
        }
      } catch (Exception e) {
        return;
      }

      settleLog = dayendSettleService.doCreateSettleLog(); //记录日志

      //step1: 账户校验
      long t1 = System.currentTimeMillis();
      if (!checkAccounts()) {
        logger.error("账户余额校验出错，退出结算！");
        return;
      }
      long t2 = System.currentTimeMillis();
      logger.info("===== step1: 日终结算【账户校验】耗时 " + (t2 - t1) + " ms");

      //step2: 对账判断
      long t3 = System.currentTimeMillis();
      if(!checkChkfiles()){
        logger.error("对账未完成，退出结算！");
        return;
      }
      long t4 = System.currentTimeMillis();
      logger.info("===== step2: 日终结算【对账判断】耗时 " + (t4 - t3) + " ms");

      //step3: 日结
      long t5 = System.currentTimeMillis();
      if (!doSettleProcess()) {
        logger.error("日结出错：" + settleLog.getErrmsg());
        return;
      }
      long t6 = System.currentTimeMillis();
      logger.info("===== step3: 日终结算【日结】耗时 " + (t6 - t5) + " ms");


    } catch (Exception e) {
      logger.error("日终结算报错：" + (!StringUtil.isEmpty(e.getMessage()) ? e.getMessage() : e.getClass().getName()));
      e.printStackTrace();
    } finally {
      if (null != lock) {
        lock.setTaskstatus(0);
        lock.setTasktime(systemUtilService.getSysdatetime().getHostdatetime());
        systemUtilService.updateTaskLock(lock);
      }
    }
  }

  private boolean checkAccounts(){
    //TODO: 账户余额校验，生成账户日结表数据
    return true;
  }

  private boolean checkChkfiles(){
    //TODO: 结算前是否要求所有对账完成
    return true;
  }

  private boolean doSettleProcess() {
    try {
      boolean ret = dayendSettleService.doDayendSettle();
      if (ret) {
        dayendSettleService.doUpdateSettleLog(settleLog.update("0", "成功结算"));
      }
      return ret;
    } catch (Exception e) {
      if (!StringUtil.isEmpty(e.getMessage())) {
        dayendSettleService.doUpdateSettleLog(settleLog.update("-9", e.getMessage()));
      } else {
        e.printStackTrace();
        dayendSettleService.doUpdateSettleLog(settleLog.update("-8", e.getClass().getName()));
      }
      return false;
    }
  }
}
