package com.supwisdom.dlpay.api.dao;

import com.supwisdom.dlpay.api.domain.TAccount;
import com.supwisdom.dlpay.api.repositories.TAccountRepository;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.*;

import javax.persistence.LockModeType;
import javax.persistence.QueryHint;

public interface AccountDao extends JpaRepository<TAccount, String>, TAccountRepository {

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @Query("select a from TAccount a where a.accno = ?1")
  TAccount getByAccnoForUpdate(String accno);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @QueryHints({@QueryHint(name = "javax.persistence.lock.timeout", value = "0")})
  @Query("select a from TAccount a where a.accno = ?1")
  TAccount getByAccnoForUpdateNowait(String accno);

  TAccount findByUserid(String userid);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @Query("select a from TAccount a where a.userid = ?1")
  TAccount getByUseridForUpdate(String userid);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @QueryHints({@QueryHint(name = "javax.persistence.lock.timeout", value = "0")})
  @Query("select a from TAccount a where a.userid = ?1")
  TAccount getByUseridForUpdateNowait(String userid);

  @Query("select a from TAccount a where a.userid = ?1 and a.subjno=?2")
  TAccount findByUseridAndSubjno(String userid, String subjno);

  @Modifying
  @Query("update TAccount t set t.availbal=t.availbal-?3 , t.balance=t.balance-?3 where t.accno=?1 and t.availbal=?2")
  int updateAccountBalance(String accno, Double availbal, Double amount);

  Page<TAccount> findAllByAccnameContaining(String accname, Pageable pageable);
}
