package com.supwisdom.dlpay.api.domain;

import com.supwisdom.dlpay.framework.domain.TSubject;

import javax.persistence.*;

import static javax.persistence.FetchType.LAZY;

@Entity
@Table(name = "TB_TRANSACTIONMAIN",
    indexes = {@Index(name = "transmain_accdate", columnList = "accdate"),
        @Index(name = "transmain_status", columnList = "status"),
        @Index(name = "transmain_outtrade", unique = true, columnList = "outid, outtradeno")})
public class TTransactionMain {
  @Id
  @Column(name = "refno", nullable = false, length = 32)
  private String refno;

  @Column(name = "accdate", nullable = false, length = 8)
  private String accdate;

  @Column(name = "person")
  private Boolean person = false;

  @Column(name = "shop")
  private Boolean shop = false;

  @Column(name = "subject")
  private Boolean subject = false;

  @Column(name = "status", length = 20)
  private String status = "none";

  @Column(name = "outtradeno", length = 60)
  private String outTradeNo = "";

  @Column(name = "outid", length = 60)
  private String outId;

  @Column(name = "reverse_flag", nullable = false, length = 10)
  private String reverseFlag = "none";

  @OneToOne(targetEntity = TPersondtl.class, mappedBy = "refno", fetch = LAZY)
  private TPersondtl personDtl;

  @OneToOne(targetEntity = TShopdtl.class, mappedBy = "refno", fetch = LAZY)
  private TShopdtl shopDtl;

  @OneToOne(targetEntity = TSubjectdtl.class, mappedBy = "refno", fetch = LAZY)
  private TSubjectdtl subjectDtl;

  public String getRefno() {
    return refno;
  }

  public void setRefno(String refno) {
    this.refno = refno;
  }

  public String getAccdate() {
    return accdate;
  }

  public void setAccdate(String accdate) {
    this.accdate = accdate;
  }


  public Boolean getPerson() {
    return person;
  }

  public void setPerson(Boolean person) {
    this.person = person;
  }

  public Boolean getShop() {
    return shop;
  }

  public void setShop(Boolean shop) {
    this.shop = shop;
  }

  public Boolean getSubject() {
    return subject;
  }

  public void setSubject(Boolean subject) {
    this.subject = subject;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getOutTradeNo() {
    return outTradeNo;
  }

  public void setOutTradeNo(String outTradeNo) {
    this.outTradeNo = outTradeNo;
  }

  public String getOutId() {
    return outId;
  }

  public void setOutId(String outId) {
    this.outId = outId;
  }

  public String getReverseFlag() {
    return reverseFlag;
  }

  public void setReverseFlag(String reverseFlag) {
    this.reverseFlag = reverseFlag;
  }

  public TPersondtl getPersonDtl() {
    return personDtl;
  }

  public TShopdtl getShopDtl() {
    return shopDtl;
  }

  public TSubjectdtl getSubjectDtl() {
    return subjectDtl;
  }
}
