package com.supwisdom.dlpay.framework.filter;


import com.fasterxml.jackson.databind.ObjectMapper;
import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.exception.ValidateCodeException;
import com.supwisdom.dlpay.framework.security.validate.ImageCodeUtil;
import com.supwisdom.dlpay.framework.security.validate.VerifyCode;
import com.supwisdom.dlpay.framework.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;


@Component("validateCodeFilter")
public class ValidateCodeFilter extends OncePerRequestFilter{

	/**
	 * 校验失败处理器
	 */
	@Autowired
	private AuthenticationFailureHandler myAuthenticationFailureHandler;

	/**
	 * 校验成功处理器
	 */
	@Autowired
	private AuthenticationSuccessHandler myAuthenticationSuccessHandler;
	@Autowired
	private ObjectMapper objectMapper;


	@Override
	protected void doFilterInternal(HttpServletRequest request,
																	HttpServletResponse response, FilterChain filterChain)
			throws ServletException, IOException {
		if (StringUtil.equals("/login/form", request.getRequestURI())
				&& StringUtil.equalsIgnoreCase(request.getMethod(), "post")) {
			try {
				validate(request);
			} catch (ValidateCodeException e) {
				response.setStatus(HttpStatus.OK.value());
				response.setContentType("application/json;charset=UTF-8");
				response.getWriter().write(objectMapper.writeValueAsString(JsonResult.error(400, e.getMessage())));
				//response.sendError(HttpStatus.UNAUTHORIZED.value(),e.getMessage());
				//myAuthenticationFailureHandler.onAuthenticationFailure(request, response, e);
				return;
			}
		}
		filterChain.doFilter(request, response);
	}

	private void validate(HttpServletRequest request) throws ValidateCodeException {
		VerifyCode imageCode = (VerifyCode) request.getSession().getAttribute(ImageCodeUtil.LOGIN_IMAGECODE_SESSIONKEY);
		String inputCode;
		try {
			inputCode = request.getParameter("imageCode");
		} catch (Exception e) {
			throw new ValidateCodeException("获取验证码的值失败");
		}
		if (StringUtil.isEmpty(inputCode)) {
			throw new ValidateCodeException("验证码不能为空");
		}
		if (null == imageCode) {
			throw new ValidateCodeException("验证码不存在");
		}
		if (imageCode.isExpired()) {
			request.getSession().removeAttribute(ImageCodeUtil.LOGIN_IMAGECODE_SESSIONKEY);
			throw new ValidateCodeException("验证码已过期");
		}
		if (!StringUtil.equalsIgnoreCase(imageCode.getText(), inputCode)) {
			throw new ValidateCodeException("验证码不匹配");
		}
		request.getSession().removeAttribute(ImageCodeUtil.LOGIN_IMAGECODE_SESSIONKEY);
	}

}
