package com.supwisdom.dlpay.system.controller;

import com.supwisdom.dlpay.api.domain.TAccount;
import com.supwisdom.dlpay.api.domain.TPerson;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.WebConstant;
import com.supwisdom.dlpay.system.bean.PersonParamBean;
import com.supwisdom.dlpay.system.service.UserDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class UserController {
    @Autowired
    private UserDataService userDataService;

    @GetMapping("/user/index")
    public String sysparaView() {
        return "system/user/index";
    }
    @GetMapping("/user/list")
    @PreAuthorize("hasPermission('/user/list','')")
    @ResponseBody
    public PageResult<TPerson> getDataList(@RequestParam("page") Integer pageNo,
                                           @RequestParam("limit") Integer pageSize,
                                           @RequestParam(value = "searchkey", required = false) String searchKey) {
        try {
            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
            PersonParamBean searchBean = new PersonParamBean();
            searchBean.setPageNo(pageNo);
            searchBean.setName(searchKey);
            searchBean.setPageSize(pageSize);
            return userDataService.getPersonsByKey(searchBean);
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }
    @GetMapping("/user/acc")
    public String acc() {
        return "system/user/account";
    }

    @GetMapping("/user/account")
    @PreAuthorize("hasPermission('/user/account','')")
    @ResponseBody
    public PageResult<TAccount> getDataAccountList(@RequestParam("page") Integer pageNo,
                                                   @RequestParam("limit") Integer pageSize,
                                                   @RequestParam(value = "searchkey", required = false) String searchKey) {
        try {
            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
            PersonParamBean searchBean = new PersonParamBean();
            searchBean.setPageNo(pageNo);
            searchBean.setName(searchKey);
            searchBean.setPageSize(pageSize);
            return userDataService.getAccountsByKey(searchBean);
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }
}
