package com.supwisdom.dlpay.api.service

import com.supwisdom.dlpay.api.TransactionBuilder
import com.supwisdom.dlpay.api.TransactionResult
import org.springframework.transaction.annotation.Propagation
import org.springframework.transaction.annotation.Transactional

interface TransactionService {
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun init(builder: TransactionBuilder): TransactionResult

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun wip(refno: String)

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun wip(builder: TransactionBuilder): TransactionResult

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun fail(refno: String)

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun success(refno: String)
}