package com.supwisdom.dlpay.controller

import com.google.gson.Gson
import com.supwisdom.dlpay.MvcBaseTest
import com.supwisdom.dlpay.api.bean.OpenUserParam
import com.supwisdom.dlpay.api.bean.QueryUserParam
import com.supwisdom.dlpay.api.domain.TAccount
import com.supwisdom.dlpay.api.domain.TPerson
import org.junit.Assert
import org.junit.Test
import org.springframework.http.MediaType
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders
import org.springframework.test.web.servlet.result.MockMvcResultHandlers
import org.springframework.test.web.servlet.result.MockMvcResultMatchers


class UserControllerTest : MvcBaseTest() {

    class RetBean {
        var userid: String = ""
        var retcode: Int = 0
        lateinit var person: TPerson
        lateinit var account: TAccount
    }

    @Test
    fun open() {
        val userParam = OpenUserParam()
        userParam.uid = ""//random req
        userParam.name = "测试名称"

        val ret = mvc.perform(MockMvcRequestBuilders.post("/api/user/open").content(gson.toJson(userParam))
                .contentType(MediaType.APPLICATION_JSON))
                .andExpect(MockMvcResultMatchers.status().isOk)
                .andDo(MockMvcResultHandlers.print())
                .andReturn()
        val res = ret.response.contentAsString
        Assert.assertNotNull(res)
        val retBean = gson.fromJson(res, RetBean::class.java)
        Assert.assertNotNull(retBean)
        Assert.assertEquals(0, retBean.retcode)
        Assert.assertNotNull(retBean.userid)
        Assert.assertNotEquals("", retBean.userid)
    }

    @Test
    fun get() {

        val userParam = QueryUserParam()
        userParam.uid = "testuseruniqueId"//测试用
        val gson = Gson()
        val ret = mvc.perform(MockMvcRequestBuilders.post("/api/user/open").content(gson.toJson(userParam))
                .contentType(MediaType.APPLICATION_JSON))
                .andExpect(MockMvcResultMatchers.status().isOk)
                .andDo(MockMvcResultHandlers.print())
                .andReturn()
        val resOpen = ret.response.contentAsString
        Assert.assertNotNull(resOpen)
        val retBeanOpen = gson.fromJson(resOpen, RetBean::class.java)
        Assert.assertNotNull(retBeanOpen)
        Assert.assertNotNull(retBeanOpen.userid)
        userParam.userid = retBeanOpen.userid

        val retGet = mvc.perform(MockMvcRequestBuilders.get("/api/user/query").content(gson.toJson(userParam))
                .contentType(MediaType.APPLICATION_JSON))
                .andExpect(MockMvcResultMatchers.status().isOk)
                .andDo(MockMvcResultHandlers.print())
                .andReturn()
        val res = retGet.response.contentAsString
        Assert.assertNotNull(res)
        val retBean = gson.fromJson(res, RetBean::class.java)
        Assert.assertNotNull(retBean)
        Assert.assertEquals(0, retBean.retcode)
        Assert.assertNotNull(retBean.person)
        Assert.assertEquals(retBeanOpen.userid, retBean.person.userid)
        Assert.assertNotNull(retBeanOpen.account)
        Assert.assertEquals(retBeanOpen.person.userid, retBean.account.userid)
    }

}