package com.supwisdom.dlpay

import org.junit.Test
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder
import org.springframework.security.crypto.password.DelegatingPasswordEncoder
import org.springframework.security.crypto.password.PasswordEncoder
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder
import org.springframework.security.crypto.scrypt.SCryptPasswordEncoder
import java.util.*


class PasswordTest {
    private fun encodePassword(pswd: String) {
        val encoders = HashMap<String, PasswordEncoder>()
        encoders["bcrypt"] = BCryptPasswordEncoder()
        encoders["pbkdf2"] = Pbkdf2PasswordEncoder()
        encoders["scrypt"] = SCryptPasswordEncoder()
        val passwordEncoder = DelegatingPasswordEncoder("bcrypt", encoders)
        println(passwordEncoder.encode(pswd))

    }

    @Test
    fun testPassword() {
        encodePassword("123456")
    }
}