package com.supwisdom.dlpay.framework.domain;

import javax.persistence.*;

@Entity
@Table(name = "TB_VOUCHERENTRY")
@IdClass(TVoucherEntryPK.class)
public class TVoucherEntry {
  @Id
  @Column(name = "VOUCHERID",nullable = false, length = 32)
  private String voucherid;

  @Id
  @Column(name = "ENTRYID", precision = 2)
  private Integer entryid;

  @Column(name="SUBJNO", length = 10)
  private String subjno;

  @Column(name="ACCNO", length = 32)
  private String accno;

  @Column(name="DRAMT", precision = 15, scale = 2)
  private Double dramt;

  @Column(name="CRAMT", precision = 15, scale = 2)
  private Double cramt;

  @Column(name="BALANCE", precision = 15, scale = 2)
  private Double balance;

  @Column(name="BALFLAG", precision = 1)
  private Integer balflag;

  @Column(name="SUMMARY", length = 240)
  private String summary;

  @Column(name="OPPSUBJNO", length = 10)
  private String oppsubjno;

  @Column(name="OPPACCNO", length = 32)
  private String oppaccno;

  @Column(name = "OPPNAME", length = 240)
  private String oppname;

  public TVoucherEntry() {
  }

  public TVoucherEntry(String voucherid, Integer entryid, String subjno, String accno, Double dramt, Double cramt, String summary, String oppsubjno, String oppaccno) {
    this.voucherid = voucherid;
    this.entryid = entryid;
    this.subjno = subjno;
    this.accno = accno;
    this.dramt = dramt;
    this.cramt = cramt;
    this.summary = summary;
    this.oppsubjno = oppsubjno;
    this.oppaccno = oppaccno;
  }

  public TVoucherEntry(String voucherid, Integer entryid, String subjno, String accno, Double dramt, Double cramt, Double balance, Integer balflag, String summary, String oppsubjno, String oppaccno, String oppname) {
    this.voucherid = voucherid;
    this.entryid = entryid;
    this.subjno = subjno;
    this.accno = accno;
    this.dramt = dramt;
    this.cramt = cramt;
    this.balance = balance;
    this.balflag = balflag;
    this.summary = summary;
    this.oppsubjno = oppsubjno;
    this.oppaccno = oppaccno;
    this.oppname = oppname;
  }

  public String getVoucherid() {
    return voucherid;
  }

  public void setVoucherid(String voucherid) {
    this.voucherid = voucherid;
  }

  public Integer getEntryid() {
    return entryid;
  }

  public void setEntryid(Integer entryid) {
    this.entryid = entryid;
  }

  public String getSubjno() {
    return subjno;
  }

  public void setSubjno(String subjno) {
    this.subjno = subjno;
  }

  public String getAccno() {
    return accno;
  }

  public void setAccno(String accno) {
    this.accno = accno;
  }

  public Double getDramt() {
    return dramt;
  }

  public void setDramt(Double dramt) {
    this.dramt = dramt;
  }

  public Double getCramt() {
    return cramt;
  }

  public void setCramt(Double cramt) {
    this.cramt = cramt;
  }

  public Double getBalance() {
    return balance;
  }

  public void setBalance(Double balance) {
    this.balance = balance;
  }

  public Integer getBalflag() {
    return balflag;
  }

  public void setBalflag(Integer balflag) {
    this.balflag = balflag;
  }

  public String getSummary() {
    return summary;
  }

  public void setSummary(String summary) {
    this.summary = summary;
  }

  public String getOppsubjno() {
    return oppsubjno;
  }

  public void setOppsubjno(String oppsubjno) {
    this.oppsubjno = oppsubjno;
  }

  public String getOppaccno() {
    return oppaccno;
  }

  public void setOppaccno(String oppaccno) {
    this.oppaccno = oppaccno;
  }

  public String getOppname() {
    return oppname;
  }

  public void setOppname(String oppname) {
    this.oppname = oppname;
  }
}
