package com.supwisdom.dlpay.framework.util;

import org.apache.log4j.Logger;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class APIRequestParam {
  @Sign
  private String sign;
  @Sign
  private String sign_type;
  @Sign
  private String version;

  private static final Logger logger = Logger.getLogger(APIRequestParam.class);

  public String getSign() {
    return sign;
  }

  public void setSign(String sign) {
    this.sign = sign;
  }

  public String getSign_type() {
    return sign_type;
  }

  public void setSign_type(String sign_type) {
    this.sign_type = sign_type;
  }

  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  private boolean calcSignAndCheck(Map<String, String> map, String key) {
    String sign = map.get("sign");
    String signType = map.get("sign_type") == null ? "MD5" : map.get("sign_type");
    if (StringUtil.isEmpty(sign)) return false;

    String signdata = StringUtil.createLinkString(StringUtil.paraFilter(map));
    logger.info("signdata=[" + signdata + "]");

    String calcSign = null;
    //fixme: 根据 signType 计算签名
    if ("MD5".equalsIgnoreCase(signType)) {
      calcSign = MD5.encodeByMD5(signdata + key); //默认MD5
    }

    if (sign.equalsIgnoreCase(calcSign)) {
      return true;
    }
    return false;
  }

  public boolean checkSign(String key){
    Class clazz = this.getClass();
    Map<String, String> paramMap = new HashMap<>();
    Method[] allGetter = clazz.getMethods();

    for (Method meth : allGetter) {
      if (meth.getName().startsWith("get") || meth.getName().startsWith("is")) {
        String fieldName = Introspector.decapitalize(meth.getName().substring(meth.getName().startsWith("get") ? 3 : 2));
        Field field;
        try {
          field = clazz.getDeclaredField(fieldName);
        } catch (NoSuchFieldException e) {
          try {
            field = clazz.getSuperclass().getDeclaredField(fieldName);
          } catch (NoSuchFieldException e1) {
//            e1.printStackTrace();
            continue;
          }
        }

        if (field.isAnnotationPresent(Sign.class)) {
          Object value;
          try {
            value = meth.invoke(this);
          } catch (Exception e) {
            e.printStackTrace();
            continue;
          }
          paramMap.put(fieldName, value == null ? null : value.toString());
        }
      }
    }
    return calcSignAndCheck(paramMap,key);
  }
}
