package com.supwisdom.dlpay.framework.util;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import java.io.*;
import java.util.*;

public class XmlUtils {
	public static <T> String getObjectToXml(T object) throws IOException {
		ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
		
		try {
			JAXBContext context = JAXBContext.newInstance(object.getClass());
			// 将对象转变为xml Object------XML
			// 指定对应的xml文件
			Marshaller marshaller = context.createMarshaller();
			marshaller.setProperty(Marshaller.JAXB_ENCODING,"gbk");//编码格式 
			marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, false);// 是否格式化生成的xml串
			marshaller.setProperty(Marshaller.JAXB_FRAGMENT, true);// 是否省略xml头信息

			// 将对象转换为对应的XML文件
			marshaller.marshal(object, byteArrayOutputStream);
		} catch (JAXBException e) {

			e.printStackTrace();
		}
		// 转化为字符串返回
		String xmlContent = new String(byteArrayOutputStream.toByteArray(),
				"gbk");
		return xmlContent;
	}

	public static <T> T getXmlToObject(String xmlContent, Class clazz) {
		try {
			JAXBContext context = JAXBContext.newInstance(clazz);
			// xml转换为对象 XML------Object
			InputStream inputStream;
			try {
				inputStream = new ByteArrayInputStream(
						xmlContent.getBytes("GBK"));
				Unmarshaller um = context.createUnmarshaller();

				return (T) um.unmarshal(inputStream);
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}catch (Exception e) {
				e.printStackTrace();
			}
		} catch (JAXBException e) {

			e.printStackTrace();
		}
		return null;
	}
	
	public static <T> T getXmlToObject(String xmlContent,String charset, Class clazz) {
		try {
			JAXBContext context = JAXBContext.newInstance(clazz);
			// xml转换为对象 XML------Object
			InputStream inputStream;
			try {
				inputStream = new ByteArrayInputStream(
						xmlContent.getBytes(charset));
				Unmarshaller um = context.createUnmarshaller();

				return (T) um.unmarshal(inputStream);
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}catch (Exception e) {
				e.printStackTrace();
			}
		} catch (JAXBException e) {

			e.printStackTrace();
		}
		return null;
	}

	public static Map<String, String> parseXml(String xml) throws Exception {
		Map<String, String> map = new HashMap<String, String>();
		Document document = DocumentHelper.parseText(xml);
		Element root = document.getRootElement();
		List<Element> elementList = root.elements();
		for (Element e : elementList)
			map.put(e.getName(), e.getText());
		return map;
	}

}
