package com.supwisdom.dlpay.system.controller;

import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.framework.domain.TBusinesspara;
import com.supwisdom.dlpay.framework.domain.TSyspara;
import com.supwisdom.dlpay.framework.service.SystemUtilService;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.WebConstant;
import com.supwisdom.dlpay.system.service.ParamService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ParamController {
  @Autowired
  private ParamService paramService;
  @Autowired
  private SystemUtilService systemUtilService;

  @GetMapping("/param/syspara")
  public String sysparaView() {
    return "system/param/syspara";
  }

  @GetMapping("/param/sysparalist")
  @PreAuthorize("hasPermission('/param/syspara','')")
  @ResponseBody
  public PageResult<TSyspara> getDataList(@RequestParam("page") Integer pageNo,
                                          @RequestParam("limit") Integer pageSize,
                                          @RequestParam(value = "paraid", required = false) Integer paraid,
                                          @RequestParam(value = "paraname", required = false) String paraname) {
    try {
      if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
      if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
      return paramService.getSysparaPage(paraid, paraname, pageNo, pageSize);
    } catch (Exception e) {
      e.printStackTrace();
      return new PageResult<>(99, "系统查询错误");
    }
  }

  @PostMapping("/param/sysparaupdate")
  @PreAuthorize("hasPermission('/param/sysparaupdate','')")
  @ResponseBody
  public JsonResult updateSyspara(@RequestParam("paraid") Integer paraid,
                                  @RequestParam("paraval") String paraval) {
    if (null == paraid || null == paraval) {
      return JsonResult.error("参数传递错误");
    } else if (paraval.length() > 30) {
      return JsonResult.error("参数值过长");
    }
    TSyspara syspara = paramService.getSysparaByParaid(paraid);
    if (null == syspara) {
      return JsonResult.error("全局参数不存在");
    }
    syspara.setParaval(paraval);
    syspara.setLastsaved(systemUtilService.getSysdatetime().getHostdatetime());
    if (syspara.checkValueInvalid()) {
      return JsonResult.error("参数值格式错误");
    }
    try {
      if (paramService.updateSyspara(syspara)) {
        return JsonResult.ok("修改成功");
      } else {
        return JsonResult.error("修改失败");
      }
    } catch (Exception e) {
      e.printStackTrace();
      return JsonResult.error("系统处理异常");
    }
  }


  /**
   * ====================================================
   *              业务参数配置
   * ====================================================
   */
  @GetMapping("/param/businesspara")
  public String busiparaView() {
    return "system/param/businesspara";
  }

  @PostMapping("/param/businessparalist")
  @PreAuthorize("hasPermission('/param/businesspara','')")
  @ResponseBody
  public PageResult<TBusinesspara> getDataList(@RequestParam("page") Integer pageNo,
                                               @RequestParam("limit") Integer pageSize,
                                               @RequestParam(value = "paraname", required = false) String paraname) {
    try {
      if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
      if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
      return paramService.getBusinessparaPage(paraname, pageNo, pageSize);
    } catch (Exception e) {
      e.printStackTrace();
      return new PageResult<>(99, "系统查询错误");
    }
  }


}
