package com.supwisdom.dlpay.system.service;

import com.supwisdom.dlpay.framework.domain.TBusinesspara;
import com.supwisdom.dlpay.framework.domain.TSyspara;
import com.supwisdom.dlpay.framework.util.PageResult;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;


public interface ParamService {
  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  PageResult<TSyspara> getSysparaPage(Integer paraid, String paraname, int pageNo, int pageSize);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  TSyspara getSysparaByParaid(int paraid);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  boolean updateSyspara(TSyspara syspara);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  PageResult<TBusinesspara> getBusinessparaPage(String paraname, int pageNo, int pageSize);
}
