package com.supwisdom.dlpay.system.service;

import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.framework.domain.TPermission;
import com.supwisdom.dlpay.framework.domain.TResource;
import com.supwisdom.dlpay.framework.domain.TRole;
import com.supwisdom.dlpay.framework.domain.TRoleFunction;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.system.bean.FunctionSearchBean;
import com.supwisdom.dlpay.system.bean.ZTreeNode;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface RoleService {
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
    List<TRole> findAllRoles();

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
    TRole findRoleByRoleid(String roleid);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
    TResource findResourceByURI(String uri);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
    TRoleFunction findRoleFunctionByRoleIdAndFunctionId(String roleid, Integer functionid);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
    PageResult<TRole> getRolesByKey(FunctionSearchBean param);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    JsonResult saveRole(TRole role);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
    List<TRoleFunction> getRoleFuncByRoleid(String roleId);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
    TPermission findByRoleIdAndResid(String roleFuncId, Integer resid);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    JsonResult saveRoleFuncId(String roleId, String funcs);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
    List<ZTreeNode> findByRoleIdNative(String roleId);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    JsonResult deleteRole(String roleid);
}
