package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.framework.dao.BusinessparaDao;
import com.supwisdom.dlpay.framework.dao.SysparaDao;
import com.supwisdom.dlpay.framework.domain.TBusinesspara;
import com.supwisdom.dlpay.framework.domain.TSyspara;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.system.service.ParamService;
import com.supwisdom.dlpay.util.ConstantUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;


@Service
public class ParamServiceImpl implements ParamService {
  @Autowired
  private SysparaDao sysparaDao;
  @Autowired
  private BusinessparaDao businessparaDao;

  @Override
  public PageResult<TSyspara> getSysparaPage(Integer paraid, String paraname, int pageNo, int pageSize) {
    Pageable pageable = PageRequest.of(pageNo - 1, pageSize, Sort.by("paraid"));
    Page<TSyspara> page = sysparaDao.findAll(new Specification<TSyspara>() {
      @Override
      public Predicate toPredicate(Root<TSyspara> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        List<Predicate> predicates = new ArrayList<>();
        if (null != paraid) {
          predicates.add(criteriaBuilder.equal(root.get("paraid").as(Integer.class), paraid));
        }
        if (!StringUtil.isEmpty(paraname)) {
          predicates.add(criteriaBuilder.like(root.get("paraname").as(String.class), "%" + paraname.trim() + "%"));
        }
        predicates.add(criteriaBuilder.equal(root.get("displayflag").as(String.class), ConstantUtil.ENABLE_YES));
        return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
      }
    }, pageable);
    return new PageResult<>(page);
  }

  @Override
  public TSyspara getSysparaByParaid(int paraid) {
    return sysparaDao.findByParaid(paraid);
  }

  @Override
  public boolean updateSyspara(TSyspara syspara) {
    if (null != syspara) {
      sysparaDao.save(syspara);
      return true;
    }
    return false;
  }

  @Override
  public PageResult<TBusinesspara> getBusinessparaPage(String paraname, int pageNo, int pageSize) {
    Pageable pageable = PageRequest.of(pageNo - 1, pageSize, Sort.by("parakey"));
    if (!StringUtil.isEmpty(paraname)) {
      return new PageResult<>(businessparaDao.findAllByParakeyContaining(paraname.trim(), pageable));
    }
    return new PageResult<>(businessparaDao.findAll(pageable));
  }

}
