package com.supwisdom.dlpay.api.service.impl

import com.supwisdom.dlpay.api.dao.SourceTypeDao
import com.supwisdom.dlpay.api.dao.ShopPaytypeConfigDao
import com.supwisdom.dlpay.api.dao.ShopPaytypeDao
import com.supwisdom.dlpay.api.service.ConsumePayService
import com.supwisdom.dlpay.exception.TransactionProcessException
import com.supwisdom.dlpay.framework.util.TradeErrorCode
import com.supwisdom.dlpay.util.ConstantUtil
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class ConsumePayServiceImpl : ConsumePayService {
    @Autowired
    lateinit var sourceTypeDao: SourceTypeDao
    @Autowired
    lateinit var shopPaytypeDao: ShopPaytypeDao
    @Autowired
    lateinit var shopPaytypeConfigDao: ShopPaytypeConfigDao

    override fun checkShopPaytype(shopaccno: String, sourceType: String, anonymousflag: Boolean?): Boolean {
        sourceTypeDao.getBySourceType(sourceType).let {
            if (null == it) {
                throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "系统不支持支付方式[$sourceType]")
            } else {
                if (!it.enable || !it.consumeEnable) {
                    throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "系统未启用支付方式[$sourceType]消费")
                }
                if (true == anonymousflag && !it.anonymousEnable) {
                    throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "系统支付方式[$sourceType]未启用匿名消费")
                }
            }
        }
        shopPaytypeDao.getById(sourceType, shopaccno).let {
            if (null == it) {
                throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[$shopaccno]未启用支付方式[$sourceType]")
            } else {
                if (!it.consumeEnable) {
                    throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[$shopaccno]未启用支付方式[$sourceType]")
                }
                if (true == anonymousflag && !it.anonymousEnable) {
                    throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[$shopaccno]的支付方式[$sourceType]未启用匿名消费")
                }
            }
        }
        return true
    }

    override fun getPaytypeConfig(paytype: String, shopaccno: String,
                                  anonymousflag: Boolean?, ignoreStatus: Boolean?): Map<String, String?> {
        sourceTypeDao.getBySourceType(paytype).let {
            if (null == it) {
                throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "系统不支持支付方式[$paytype]")
            } else {
                //对账取配置时不关心状态，不能报错
                if (true != ignoreStatus && (!it.enable || !it.consumeEnable)) {
                    throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "系统未启用支付方式[$paytype]消费")
                }
                if (true != ignoreStatus && true == anonymousflag && !it.anonymousEnable) {
                    throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "系统支付方式[$paytype]未启用匿名消费")
                }
            }
        }

        shopPaytypeDao.getById(paytype, shopaccno).let {
            if (null == it) {
                throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[$shopaccno]未启用支付方式[$paytype]")
            } else {
                //对账取配置时不关心状态，不能报错
                if (true != ignoreStatus && !it.consumeEnable) {
                    throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[$shopaccno]未启用支付方式[$paytype]")
                }
                if (true != ignoreStatus && true == anonymousflag && !it.anonymousEnable) {
                    throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[$shopaccno]的支付方式[$paytype]未启用匿名消费")
                }
            }
        }

        shopPaytypeConfigDao.getShopPaytypeConfigs(paytype, shopaccno)?.let {
            if (it.size < 1) {
                throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[$shopaccno]的支付方式[$paytype]未配置参数")
            } else {
                val result = mutableMapOf<String, String?>()
                it.forEach { paytypeConfig ->
                    result.plus(mapOf(paytypeConfig.configid to paytypeConfig.configValue))
                }
                return result
            }
        }
                ?: throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[$shopaccno]的支付方式[$paytype]未配置参数")
    }

    override fun getUserdtlExtendParamMap(refno: String): Map<String, String> {
        TODO("未实现方法")
    }
}