package com.supwisdom.dlpay.api.service

import com.supwisdom.dlpay.api.bean.OpenShopParam
import com.supwisdom.dlpay.framework.domain.TShop
import org.springframework.transaction.annotation.Propagation
import org.springframework.transaction.annotation.Transactional

/**
 * Created by shuwei on 2019/4/15.
 */
interface ShopService {
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class))
    fun registerShop(param: OpenShopParam): TShop

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun findByThirdUniqueId(uniqueId: String): TShop?

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun findByShopId(shopid: Int): TShop

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun findByShopBySearch(shopid: Int?, shopaccno: String?, shopUniqueId: String?): TShop?
}