package com.supwisdom.dlpay.framework.service.impl

import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.jcabi.manifests.Manifests
import com.supwisdom.dlpay.api.bean.ConsumeFeetype
import com.supwisdom.dlpay.exception.RequestParamCheckException
import com.supwisdom.dlpay.exception.TransactionProcessException
import com.supwisdom.dlpay.framework.core.JwtConfig
import com.supwisdom.dlpay.framework.core.JwtTokenUtil
import com.supwisdom.dlpay.framework.dao.ApiClientDao
import com.supwisdom.dlpay.framework.service.CommonService
import com.supwisdom.dlpay.framework.util.StringUtil
import com.supwisdom.dlpay.framework.util.TradeErrorCode
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import javax.servlet.http.HttpServletRequest

@Service
class CommonServiceImpl : CommonService {
    @Autowired
    lateinit var jwtConfig: JwtConfig
    @Autowired
    lateinit var apiClientDao: ApiClientDao

    private var jwtUtil: JwtTokenUtil? = null

    private fun getUtil(): JwtTokenUtil {
        if (jwtUtil == null) {
            jwtUtil = JwtTokenUtil((jwtConfig))
        }
        return jwtUtil as JwtTokenUtil
    }

    override fun getSystemVersion(): String {
        return try {
            Manifests.read("Payapi-Version") ?: "version 1.0"
        } catch (ex: Exception) {
//            ex.printStackTrace()
            "unknown"
        }
    }

    override fun getRequestAppid(request: HttpServletRequest): String {
        request.getHeader(jwtConfig.header).let {
            if (null != it && it.startsWith(jwtConfig.tokenHeader)) {
                val claims = getUtil().verifyToken(it.substring(jwtConfig.tokenHeader.length))
                val uid = claims["uid"]?.toString()
                if (!StringUtil.isEmpty(uid)) {
                    return uid as String
                }
            }

            throw TransactionProcessException(TradeErrorCode.BUSINESS_APPID_NOTFOUND, "APPID未找到") //报错
        }
    }

    override fun getAppidSecretByRequest(request: HttpServletRequest): String {
        return getSecretByAppid(getRequestAppid(request))
    }

    override fun getSecretByAppid(appid: String): String {
        return apiClientDao.findByAppid(appid).let {
            if (null != it)
                it.secret
            else
                throw TransactionProcessException(TradeErrorCode.BUSINESS_APPID_NOTFOUND, "APPID记录未找到") //报错
        }
    }
}