package com.supwisdom.dlpay.api.domain;

import javax.persistence.*;

@Entity
@Table(name = "TB_SUBJECTDTL",
    indexes = {@Index(name = "subjdtl_accdate", columnList = "accdate"),
        @Index(name = "subjdtl_subjno", columnList = "subjno")})
public class TSubjectdtl {
  @Id
  @Column(name = "refno", length = 32, nullable = false)
  private String refno;

  @Column(name = "accdate", length = 8, nullable = false)
  private String accdate;

  @Column(name = "subjno", length = 10, nullable = false)
  private String subjectno;

  @Column(name = "subjname", length = 200)
  private String subjectName;

  @Column(name = "amount", scale = 2, precision = 15)
  private Double amount;

  @Column(name = "tradecode", precision = 8)
  private Integer tradeCode;

  @Column(name = "transdate", length = 8)
  private String transDate;

  @Column(name = "transtime", length = 6)
  private String transTime;

  @Column(name = "paytype", length = 20)
  private String payType;

  @Column(name = "payinfo", length = 200)
  private String payInfo;

  @Column(name = "OPPOSITEACCNO", length = 20)
  private String oppositeAccNo;

  @Column(name = "OPPOSITEACCNAME", length = 200)
  private String oppositeAccName;

  @Column(name = "status", length = 20)
  private String status;

  public String getRefno() {
    return refno;
  }

  public void setRefno(String refno) {
    this.refno = refno;
  }

  public String getAccdate() {
    return accdate;
  }

  public void setAccdate(String accdate) {
    this.accdate = accdate;
  }

  public String getSubjectno() {
    return subjectno;
  }

  public void setSubjectno(String subjectno) {
    this.subjectno = subjectno;
  }

  public String getSubjectName() {
    return subjectName;
  }

  public void setSubjectName(String subjectName) {
    this.subjectName = subjectName;
  }

  public Double getAmount() {
    return amount;
  }

  public void setAmount(Double amount) {
    this.amount = amount;
  }

  public String getTransDate() {
    return transDate;
  }

  public void setTransDate(String transDate) {
    this.transDate = transDate;
  }

  public String getTransTime() {
    return transTime;
  }

  public void setTransTime(String transTime) {
    this.transTime = transTime;
  }

  public String getPayType() {
    return payType;
  }

  public void setPayType(String payType) {
    this.payType = payType;
  }

  public String getPayInfo() {
    return payInfo;
  }

  public void setPayInfo(String payInfo) {
    this.payInfo = payInfo;
  }

  public String getOppositeAccNo() {
    return oppositeAccNo;
  }

  public void setOppositeAccNo(String oppositeAccNo) {
    this.oppositeAccNo = oppositeAccNo;
  }

  public String getOppositeAccName() {
    return oppositeAccName;
  }

  public void setOppositeAccName(String oppositeAccName) {
    this.oppositeAccName = oppositeAccName;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public Integer getTradeCode() {
    return tradeCode;
  }

  public void setTradeCode(Integer tradeCode) {
    this.tradeCode = tradeCode;
  }
}
