package com.supwisdom.dlpay.framework.util;

public class TradeErrorCode {

  public static final int OK = 0;

  /**
   * 10000 开始表示交易数据错误
   */
  public static final int INPUT_DATA_ERROR = 10000;


  /**
   * 账户不存在
   * */
  public static final int ACCOUNT_NOT_EXISTS = 10001;

  /**
   * 账户余额不足
   */
  public static final int SHORT_BALANCE_ERROR = 10002;

  /**
   * 个人账户状态异常
   */
  public static final int PERSON_STATUS_ERROR = 10003;

  /**
   * 交易记录不存在
   */
  public static final int TRANSACTION_NOT_EXISTS = 10004;

  /**
   * 交易状态已完成
   */
  public static final int TRANSACTION_IS_FINISHED = 10005;

  /**
   * 交易已冲正
   */
  public static final int TRANSACTION_HAS_CANCELED = 10006;
  /**
   * 商户不存在
   * */
  public static final int SHOP_NOT_EXISTS = 10007;

  /**
   * 科目不存在
   * */
  public static final int SUBJECT_NOT_EXISTS = 10008;

  /**
   * 外部流水号重复
   * */
  public static final int OUTTRADENO_ALREADY_EXISTS = 10009;

  /**
   * 账户TAC校验异常
   * */
  public static final int ACCOUNT_TAC_ERROR = 10010;

  /**
   * 账户余额超上限
   * */
  public static final int OVERFLOW_BALANCE_ERROR = 10011;

  /**
   * 未指定明确的交易结束状态
   * */
  public static final int TRANSDTL_STATUS_ERROR = 10012;

  /**
   * 非初始化流水
   * */
  public static final int TRANSDTL_STATUS_NOT_INIT = 10013;

  /**
   * 账户交易繁忙
   * */
  public static final int ACCOUNT_TRADE_BUSY = 10014;

  /**
   * 非等待锁查询超时异常
   * */
  public static final int LOCK_READ_TIMEOUT = 10015;

  /**
   *  卡已挂失
   * */
  public static final int ACCOUNT_IS_LOSS = 10016;

  /**
   *  卡已锁定
   * */
  public static final int ACCOUNT_IS_LOCKED = 10017;

  /**
   * 费用类别未定义
   * */
  public static final int FEETYPE_NOT_EXISTS = 10018;

  /**
   * 费用类别不支持
   * */
  public static final int FEETYPE_NOT_NOSUPPORT = 10019;


  /**
   * 请求参数错误
   * */
  public static final int REQUEST_PARAM_ERROR = 20000;

  /**
   * 请求参数错误签名错误
   * */
  public static final int REQUEST_SIGN_ERROR = 20001;

  /**
   * 注册用户已经存在
   */
  public static final int REGISTER_USER_EXIST = 20003;


  //================= 业务处理错误 ==================//

  public static final int BUSINESS_DEAL_ERROR = 30000; //业务处理错误

  public static final int BUSINESS_SHOP_EXISTS = 30001; //商户已经存在

  public static final int BUSINESS_APPID_NOTFOUND = 30002; //APPID没找到

  public static final int BUSINESS_PAYTYPE_NOSUPPORT = 30003; //支付方式不支持

}
