package com.supwisdom.dlpay.api.service.impl

import com.supwisdom.dlpay.api.dao.AccountDao
import com.supwisdom.dlpay.api.domain.TAccount
import com.supwisdom.dlpay.api.service.AccountUtilServcie
import com.supwisdom.dlpay.exception.TransactionException
import com.supwisdom.dlpay.exception.TransactionProcessException
import com.supwisdom.dlpay.framework.dao.FeetypeConfigDao
import com.supwisdom.dlpay.framework.dao.ShopaccDao
import com.supwisdom.dlpay.framework.dao.SubjectDao
import com.supwisdom.dlpay.framework.domain.TFeetypeConfig
import com.supwisdom.dlpay.framework.domain.TShopacc
import com.supwisdom.dlpay.framework.domain.TSubject
import com.supwisdom.dlpay.framework.util.TradeErrorCode
import org.hibernate.exception.LockTimeoutException
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.dao.CannotAcquireLockException
import org.springframework.stereotype.Service


@Service
class AccountUtilServcieImpl : AccountUtilServcie {

    @Autowired
    lateinit var accountDao: AccountDao

    @Autowired
    lateinit var shopaccDao: ShopaccDao

    @Autowired
    lateinit var subjectDao: SubjectDao

    @Autowired
    lateinit var feetypeConfigDao: FeetypeConfigDao

    override fun readAccountForUpdateNowait(userid: String): TAccount {
        return try {
            accountDao.getByUseridForUpdateNowait(userid)
                    ?: throw TransactionProcessException(TradeErrorCode.ACCOUNT_NOT_EXISTS, "账户<$userid>不存在")
        } catch (ex: Exception) {
            when (ex) {
                is CannotAcquireLockException, is LockTimeoutException -> throw TransactionException(TradeErrorCode.ACCOUNT_TRADE_BUSY, "账户<$userid>交易繁忙，请稍后再试")
                else -> throw ex
            }
        }
    }

    override fun readAccount(userid: String): TAccount {
        return accountDao.findByUserid(userid)
                ?: throw TransactionProcessException(TradeErrorCode.ACCOUNT_NOT_EXISTS, "账户<$userid>不存在")
    }

    override fun readShopAcc(shopId: Int): TShopacc {
        return shopaccDao.findByShopid(shopId)
                ?: throw TransactionProcessException(TradeErrorCode.SHOP_NOT_EXISTS, "商户<$shopId>不存在")
    }

    override fun readShopbyShopaccno(shopaccno: String): TShopacc {
        return shopaccDao.findByShopaccno(shopaccno)
                ?: throw TransactionProcessException(TradeErrorCode.SHOP_NOT_EXISTS, "商户<$shopaccno>不存在")
    }

    override fun readSubject(subjno: String): TSubject {
        return subjectDao.findBySubjno(subjno)
                ?: throw TransactionProcessException(TradeErrorCode.SUBJECT_NOT_EXISTS, "科目<$subjno>不存在")
    }

    override fun readFeetype(feetype: String, paytype: String): TFeetypeConfig {
        return feetypeConfigDao.getById(feetype, paytype)
                ?: throw TransactionProcessException(TradeErrorCode.FEETYPE_NOT_EXISTS, "在支付方式<$paytype>下不存在费用类别<$feetype>")
    }
}
