package com.supwisdom.dlpay.api.service.impl

import com.supwisdom.dlpay.api.bean.OpenShopParam
import com.supwisdom.dlpay.framework.dao.ShopDao
import com.supwisdom.dlpay.framework.dao.ShopaccDao
import com.supwisdom.dlpay.framework.domain.TShop
import com.supwisdom.dlpay.framework.domain.TShopacc
import com.supwisdom.dlpay.framework.service.SystemUtilService
import com.supwisdom.dlpay.framework.util.Subject
import com.supwisdom.dlpay.api.service.ShopService
import com.supwisdom.dlpay.exception.TransactionProcessException
import com.supwisdom.dlpay.framework.util.StringUtil
import com.supwisdom.dlpay.framework.util.TradeDict
import com.supwisdom.dlpay.framework.util.TradeErrorCode
import com.supwisdom.dlpay.util.ConstantUtil
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

/**
 * Created by shuwei on 2019/4/15.
 */
@Service
class ShopServiceImpl : ShopService {
    @Autowired
    private lateinit var shopDao: ShopDao
    @Autowired
    private lateinit var shopaccDao: ShopaccDao
    @Autowired
    private lateinit var systemUtilService: SystemUtilService

    override fun findByThirdUniqueId(uniqueId: String): TShop? {
       return shopDao.getByThirdUniqueIdenty(uniqueId)
    }

    override fun registerShop(param: OpenShopParam): TShop {
        val systemdatetime = systemUtilService.sysdatetime
        var shop = shopDao.getByThirdUniqueIdentyForUpdate(param.shopUniqueId)
        if (null != shop) {
            throw TransactionProcessException(TradeErrorCode.BUSINESS_SHOP_EXISTS, "该商户唯一号[${param.shopUniqueId}]已经存在")
        }
        if (null != param.fshopid) {
            shopDao.getTShopByShopid(param.fshopid).let {
                if (null == it) {
                    throw TransactionProcessException(TradeErrorCode.SHOP_NOT_EXISTS, "上级商户不存在已经存在")
                }
            }
        }
        shop = shopDao.save(TShop().apply {
            fshopid = param.fshopid
            shopname = param.shopname
            shoptype = param.shoptype
            status = TradeDict.STATUS_NORMAL
            contactman = param.contactman
            idtype = param.idtype
            idno = param.idno
            mobile = param.mobile
            email = param.email
            addr = param.address
            zipcode = param.zipcode
            opendate = systemdatetime.hostdate
            thirdUniqueIdenty = param.shopUniqueId
        })
        if (ConstantUtil.SHOPTYPE_GROUP != shop.shoptype) {
            //非商户组要创建账号
            val shopaccno = String.format("2%09d", shop.shopid)
            shopaccDao.save(TShopacc().apply {
                this.shopaccno = shopaccno
                this.shopid = shop.shopid
                this.shopname = shop.shopname
                this.subjno = Subject.SUBJNO_MACHANT_INCOME
                this.status = TradeDict.STATUS_NORMAL
                this.opendate = shop.opendate
            })
            shop.shopaccno = shopaccno
            shopDao.save(shop) //更新账号
        }
        return shop
    }

    override fun findByShopId(shopid: Int): TShop {
        return shopDao.getTShopByShopid(shopid)
                ?: throw TransactionProcessException(TradeErrorCode.SHOP_NOT_EXISTS, "商户[ID=$shopid]不存在")
    }

    override fun findByShopBySearch(shopid: Int?, shopaccno: String?, shopUniqueId: String?): TShop? {
        return if (null != shopid) {
            shopDao.getTShopByShopid(shopid)
        } else if (!StringUtil.isEmpty(shopaccno)) {
            shopDao.getTShopByShopaccno(shopaccno)
        } else {
            shopDao.getByThirdUniqueIdenty(shopUniqueId)
        }
    }
}