package com.supwisdom.dlpay.api.service

import com.supwisdom.dlpay.api.bean.ModifyUserParam
import com.supwisdom.dlpay.api.bean.OpenUserParam
import com.supwisdom.dlpay.api.domain.TAccount
import com.supwisdom.dlpay.api.domain.TPerson
import com.supwisdom.dlpay.api.domain.TPersonIdentity
import com.supwisdom.dlpay.api.domain.TPointsAccount
import org.springframework.transaction.annotation.Propagation
import org.springframework.transaction.annotation.Transactional

/**
 * Created by shuwei on 2019/4/15.
 */
interface UserService {
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class))
    fun registerUser(param: OpenUserParam): TPerson

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun findByThirdUniqueIdenty(thirdUniqueIdenty: String): TPerson?

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun findByUseridOrThirdUniqueIdenty(userid: String?, thirdUniqueIdenty: String?): TPerson?

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun modifyUserInfo(person:TPerson,param: ModifyUserParam):Boolean

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun findPersonByUserid(userid: String): TPerson?

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun findAccountByUserid(userid: String, subjno:String?): TAccount?

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun findPointsAccountByUserid(userid: String): TPointsAccount?

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun findPersonIdentity(thirdUniqueIdenty: String):TPersonIdentity?

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun findPersonByIdentityCheckStatus(thirdUniqueIdenty: String): TPerson

}