package com.supwisdom.dlpay.app.controller;

import com.supwisdom.dlpay.app.service.AppService;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;
import com.supwisdom.dlpay.ncmgr.service.NcService;
import com.supwisdom.dlpay.util.RedisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/app")
public class AppController {
    protected static Logger logger = LoggerFactory.getLogger(AppController.class);

    @Autowired
    private AppService appService;
    @Autowired
    private NcService ncService;

    @RequestMapping("/appindex")
    public String impdevindex(@RequestParam(value = "userid")String userId,Model model){
        model.addAttribute("userId", userId);
        return "apph5/remoteH5";
    }

    @RequestMapping("/appMintUIindex")
    public String appMintUIindex(@RequestParam(value = "userid")String userId,Model model){
        model.addAttribute("userId", userId);
        return "apph5/remoteMintUIH5";
    }

    //根据用户使用次数加载用户有权限开门的设备---常使用设备优先的排序原则
    @ResponseBody
    @RequestMapping("/loadAppDevList")
    public Map loadAppDevList(@RequestParam(value = "userId",required = true,defaultValue = "")String userId){
        Map map = new HashMap();
        try{
            List<TNcDevice> devList = appService.findAllDevByUserId(userId);
            map.put("devList", devList);
        }catch (Exception e){
            e.printStackTrace();
        }
        return map;
    }

    //根据设备名称模糊查询
    @ResponseBody
    @RequestMapping("/searchByDevName")
    public Map searchByDevName(@RequestParam(value = "userId",required = true,defaultValue = "")String userId,
                               @RequestParam(value = "devName",required = true,defaultValue = "")String devName ){
        Map map = new HashMap();
        try{
            List<TNcDevice> devList = appService.findAllDevByUserIdAndDevName(userId,devName);
            map.put("devNameList", devList);
        }catch (Exception e){
            e.printStackTrace();
        }
        return map;
    }

    /*@RequestMapping("/appMintUIindex")
    public String loadH5DevList(Model model){
        try{
            List<TNcDevice> devList = appService.findAllDevByUserId("40000001000000000100001100000002");
            model.addAttribute("h5DevList", devList);
        }catch (Exception e){
            e.printStackTrace();
        }
        return "apph5/remoteMintUIH5";}
    */


    /**
     * App远程开门
     * @param devId
     * @return
     */
    @ResponseBody
    @RequestMapping("/openDoorById")
    public Map openDoorById(@RequestParam(value = "devId",required = true,defaultValue = "")String devId,
                            @RequestParam(value = "userId",required = true,defaultValue = "")String userId){
        Map map = new HashMap();
        String message = "";
        try {
            String ctrlcode = "1"; //---开门code   1指 开一次门
            TNcDevice ncDevice = ncService.getDevInfoByDevid(Integer.parseInt(devId));
            if (ncDevice!=null && "C".equals(ncDevice.getDevtype())){
                message = "请选择要开门的门锁!";
                map.put("message", message);
                return map;
            }
            int devNo = ncDevice.getDevno();
            String rmtDev = RedisUtil.get("remote_"+ncDevice.getDevphyid());
            if ("-5".equals(rmtDev)){ //数据库连接池异常 返回数据为 -5
                message = "缓存数据异常，请联系管理员!";
                map.put("message", message);
                return map;
            }

            if (StringUtil.isEmpty(rmtDev)) {
                rmtDev = "----------------";
            }else {
                boolean flag = judgeRemoteStr(rmtDev, devNo, ctrlcode);
                if (flag){
                    message="门已被开!";
                    map.put("message", message);
                    return map;
                }
            }

            String tmpVal = rmtDev.substring(0, devNo - 1) + ctrlcode + rmtDev.substring(devNo);
            RedisUtil.set("remote_" + ncDevice.getDevphyid(), tmpVal);
            //每次开门成功记录 此用户开门设备 次数  以便查询时根据经常使用设备进行 查询
            boolean a = appService.recordFre(userId, Integer.parseInt(devId));
            if (a=false){
                message="记录开门次数失败!";
            }

            //存储流水
            boolean b = appService.saveAppTDoorDtlByUserIdAndDevId(devId, userId);
            if (b=false){
                message=message+"流水存储失败!";
            }

        }catch (Exception e){
            e.printStackTrace();
            message = "手机开门失败!";
        }
        map.put("message", message);
        return map;
    }

    private boolean judgeRemoteStr(String rmtDev,int devNo,String ctrlCode){
        String rmtStr = rmtDev.substring(devNo-1, devNo);
        if (rmtStr.equals(ctrlCode)){
            return true;
        }
        return false;

    }
}
