package com.supwisdom.dlpay.app.domain;

import javax.persistence.*;

@Entity
@Table(name = "TB_APP_DEVFRE")
public class TAppDevFre {
    private TAppDevFreId Id;

    private Integer frequency;

    public TAppDevFre() {
    }

    public TAppDevFre(TAppDevFreId id, Integer frequency) {
        Id = id;
        this.frequency = frequency;
    }

    @EmbeddedId
    @AttributeOverrides({
            @AttributeOverride(name = "custId", column = @Column(name = "CUSTID", nullable = false, length = 32)),
            @AttributeOverride(name = "deviceId", column = @Column(name = "DEVICEID", nullable = false, length = 32)) })
    public TAppDevFreId getId() {
        return Id;
    }

    public void setId(TAppDevFreId id) {
        Id = id;
    }

    @Column(name = "FREQUENCY", nullable = false,length = 32)
    public Integer getFrequency() {
        return frequency;
    }

    public void setFrequency(Integer frequency) {
        this.frequency = frequency;
    }
}
