package com.supwisdom.dlpay.app.service;

import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface AppService {

    //根据userId获取此用户所有有权限的开门的设备--读头  并根据用户常用设备进行排序,如果为新用户则默认排序
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TNcDevice> findAllDevByUserId(String userId);

    //根据设备编号和userId存储手机远程开门流水
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveAppTDoorDtlByUserIdAndDevId(String devId,String userId);

    //根据用户和开门设备 记录开门次数
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean recordFre(String userId,int devId);

    //根据用户和设备名称 查询开门设备
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TNcDevice> findAllDevByUserIdAndDevName(String userId,String devName);

}
