package com.supwisdom.dlpay.app.service.impl;

import com.google.gson.Gson;
import com.supwisdom.dlpay.app.bean.CustomerInfo;
import com.supwisdom.dlpay.app.dao.AppDao;
import com.supwisdom.dlpay.app.domain.TAppDevFre;
import com.supwisdom.dlpay.app.domain.TAppDevFreId;
import com.supwisdom.dlpay.app.service.AppService;
import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.mainservice.dao.CardDao;
import com.supwisdom.dlpay.mainservice.dao.CustomerDao;
import com.supwisdom.dlpay.mainservice.dao.DoordtlDao;
import com.supwisdom.dlpay.mainservice.domain.TCard;
import com.supwisdom.dlpay.mainservice.domain.TCustomer;
import com.supwisdom.dlpay.mainservice.domain.TDoordtl;
import com.supwisdom.dlpay.mainservice.domain.TDoordtlId;
import com.supwisdom.dlpay.ncmgr.dao.NcDeviceDao;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;
import com.supwisdom.dlpay.util.RedisUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class AppServiceImpl implements AppService {

    @Autowired
    AppDao appDao;
    @Autowired
    NcDeviceDao ncDeviceDao;
    @Autowired
    CustomerDao customerDao;
    @Autowired
    CardDao cardDao;
    @Autowired
    DoordtlDao doordtlDao;

    @Override
    public List<TNcDevice> findAllDevByUserId(String userId) {
        return appDao.findAllDevByUserId(userId);
    }

    @Override
    public boolean saveAppTDoorDtlByUserIdAndDevId(String devId, String userId) {
        try {
            TNcDevice dev = ncDeviceDao.findDevById(Integer.parseInt(devId));
            String now = DateUtil.getNow();

            TDoordtlId tDoordtlId = new TDoordtlId();
            tDoordtlId.setTransdate(now.substring(0, 8));
            tDoordtlId.setFactoryid("XKP");
            tDoordtlId.setDoorid("XKP_" + devId);

            String doorseqno;
            String doorSeqNoTmp = RedisUtil.get("Door_Seq_No_AppRmt");//App远程开门 流水编号缓存
            if (doorSeqNoTmp == null || doorSeqNoTmp.equals("") || doorSeqNoTmp.equals("-5")) {//-5防止缓存出错,流水存储出错
                String maxAppRmtSeqNo = appDao.getMaxAppRmtSeqNo();
                String maxAppRmtSeqNoTmp;
                if (maxAppRmtSeqNo == null) {
                    maxAppRmtSeqNoTmp = "AR00000001";
                } else {
                    maxAppRmtSeqNoTmp = "AR".concat(StringUtil.leftZeroAppend(Integer.toString(Integer.parseInt(maxAppRmtSeqNo.substring(2)) + 1), 8));
                }
                RedisUtil.set("Door_Seq_No_AppRmt", maxAppRmtSeqNoTmp);
                doorseqno = maxAppRmtSeqNoTmp;
            } else {
                doorseqno = "AR".concat(StringUtil.leftZeroAppend(Integer.toString(Integer.parseInt(doorSeqNoTmp.substring(2)) + 1), 8));
                RedisUtil.set("Door_Seq_No_AppRmt", doorseqno);
            }
            tDoordtlId.setDoorseqno(doorseqno);

            TDoordtl tDoordtl = new TDoordtl();
            tDoordtl.setId(tDoordtlId);
            tDoordtl.setTranstime(now.substring(8));
            tDoordtl.setColdate(now.substring(0, 8));
            tDoordtl.setColtime(now.substring(8));

            Gson gs = new Gson();
            //从缓存读取物理卡号所对应的客户信息
            String redisAppUser = RedisUtil.get("User_" + userId);
            if (StringUtil.isEmpty(redisAppUser)) {
                //不存在则从数据库读取
                TCustomer cust = customerDao.findCustomerById(userId);
                TCard card = cardDao.findCardByCustid(userId);
                if (cust != null && card != null) {
                    //设置客户信息
                    tDoordtl.setCustid(cust.getCustid());
                    tDoordtl.setCustname(cust.getCustname());
                    tDoordtl.setCardno(card.getCardno());
                    tDoordtl.setBankcardno(card.getBankcardno());
                    tDoordtl.setCardphyid(card.getCardphyid());

                    //更新缓存信息
                    CustomerInfo customerInfo = new CustomerInfo();
                    customerInfo.setCardphyid(card.getCardphyid());
                    customerInfo.setCustid(cust.getCustid());
                    customerInfo.setCardid(card.getCardid());
                    customerInfo.setCustname(cust.getCustname() == null ? "" : cust.getCustname());
                    customerInfo.setCardno(card.getCardno() == null ? "" : card.getCardno());
                    customerInfo.setBankcardno(card.getBankcardno() == null ? "" : card.getBankcardno());

                    RedisUtil.set("User_" + userId, gs.toJson(customerInfo));
                } else {
                    //设置一个空的缓存信息，防止缓存击穿
                    CustomerInfo customerInfo = new CustomerInfo();
                    customerInfo.setCardphyid("");
                    customerInfo.setCustid("0");
                    customerInfo.setCustname("");
                    customerInfo.setCardno("");
                    customerInfo.setBankcardno("");
                    RedisUtil.set("User_" + userId, gs.toJson(customerInfo), 60 * 60 + 10 * 60);

                    tDoordtl.setCustid("");
                    tDoordtl.setCustname("");
                    tDoordtl.setCardno("");
                    tDoordtl.setBankcardno("");
                    tDoordtl.setCardphyid("");
                }
            } else {
                //存在直接设置
                CustomerInfo customerInfo = gs.fromJson(redisAppUser, CustomerInfo.class);
                tDoordtl.setCustid(userId);
                tDoordtl.setCardno(customerInfo.getCardno() == null ? "" : customerInfo.getCardno());
                tDoordtl.setBankcardno(customerInfo.getBankcardno() == null ? "" : customerInfo.getBankcardno());
                tDoordtl.setCustname(customerInfo.getCustname() == null ? "" : customerInfo.getCustname());
                tDoordtl.setCardphyid(customerInfo.getCardphyid());
            }

            tDoordtl.setStatus("ar");
            tDoordtl.setDtldesc("APP用户远程开门");
            tDoordtl.setUpdatetime(now);
            tDoordtl.setDevtype("门禁");
            tDoordtl.setDirection("");
            tDoordtl.setDirectiondesc("-");

            boolean b = doordtlDao.saveTDoordtl(tDoordtl);
            return b;
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }

    }

    @Override
    public boolean recordFre(String userId, int devId) {
        boolean flag = false;
        try {
            int fre = 0;
            String freTmp = RedisUtil.get("userId_" + userId + "_devId_" + devId + "_fre");
            if (freTmp==null || "0".equals(freTmp) || "-5".equals(freTmp)){
                fre = appDao.getDevAppFreByUserId(userId, devId);
            }else {
                fre = Integer.parseInt(freTmp);
            }

            if (fre!=0){
                appDao.updateFreByUserIdAndDevId(userId, devId, fre+1);
                RedisUtil.set("userId_" + userId + "_devId_" + devId + "_fre",fre+1+"");
            }else {
                TAppDevFreId tAppDevFreId = new TAppDevFreId();
                tAppDevFreId.setCustId(userId);
                tAppDevFreId.setDeviceId(devId);
                TAppDevFre tAppDevFre = new TAppDevFre();
                tAppDevFre.setId(tAppDevFreId);
                tAppDevFre.setFrequency(1);

                appDao.saveAppDevFre(tAppDevFre);

                RedisUtil.set("userId_" + userId + "_devId_" + devId + "_fre",1+"");
            }
            flag=true;


        }catch (Exception e){
            e.printStackTrace();
        }

        return flag;
    }

    @Override
    public List<TNcDevice> findAllDevByUserIdAndDevName(String userId, String devName) {
        return appDao.findAllDevByUserIdAndDevName(userId, devName);
    }

}
