package com.supwisdom.dlpay.doorlist.service;

import com.supwisdom.dlpay.ncmgr.domain.TNcAllottime;
import com.supwisdom.dlpay.ncmgr.domain.TNcCardlist;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface DoorlistMgrService {
    //根据设备编号和物理卡号和时间周id获取名单
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcCardlist getNcCardlist(int deviceid,String cardphyid,String timeid);

    //根据设备编号和市民卡号和时间周id获取名单
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcCardlist getNcCardlistByCardno(int deviceid,String cardno,String timeid);

    //批量保存设备名单
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean batchSaveCardList(List<TNcCardlist> tNcCardlists);

    //批量保存名单分配设备和时间
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean batchSaveAllotTime(List<TNcAllottime> tNcAllottimes);

    //根据查询条件分页获取系统管理员权限下所有名单
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getSystemCardList(String devname, String custname, String cardno, String syncstatus, String regionid, String allocatStartDate,String allocatEndDate,
                                         String operflag, int pageNo, int pageSize);

    //根据查询条件分页获取区域管理员权限下所有名单
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getOperatorCardList(String devname, String custname, String cardno, String syncstatus, String regionid, String allocatStartDate,String allocatEndDate,
                                          String operflag, int pageNo, int pageSize,String operRegionid);

    //根据查询条件分页获取楼栋管理员权限下所有名单
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getBuildingOperCardList(String devname, String custname, String cardno, String syncstatus, String allocatStartDate,String allocatEndDate,
                                              String operflag, int pageNo, int pageSize,String operid);

    //根据id查询下发设备名单
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcCardlist getNcCardlistById(String id);

    //修改设备人员名单
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean updateNcCardlist(TNcCardlist bean);

    //根据市民卡号和卡状态进行数据同步
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public void syncNcCardlistByCardnoAndStatus(String cardno,String status,String tranStatus);


}
