package com.supwisdom.dlpay.doorlist.service.impl;

import com.supwisdom.dlpay.doorlist.service.DoorlistMgrService;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.ncmgr.dao.NcAllottimeDao;
import com.supwisdom.dlpay.ncmgr.dao.NcCardListDao;
import com.supwisdom.dlpay.ncmgr.domain.TNcAllottime;
import com.supwisdom.dlpay.ncmgr.domain.TNcCardlist;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
public class DoorlistMgrServiceImpl implements DoorlistMgrService {
    @Autowired
    NcCardListDao ncCardListDao;
    @Autowired
    NcAllottimeDao ncAllottimeDao;


    @Override
    public TNcCardlist getNcCardlist(int deviceid, String cardphyid, String timeid) {
        return ncCardListDao.getNcCardlist(deviceid, cardphyid, timeid);
    }

    @Override
    public TNcCardlist getNcCardlistByCardno(int deviceid, String cardno, String timeid) {
        return null;
    }

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    @Override
    public boolean batchSaveCardList(List<TNcCardlist> tNcCardlists) {
        boolean flag = true;
        for(TNcCardlist bean:tNcCardlists){
            boolean b = ncCardListDao.saveCardlist(bean);
            if (b==false){
                flag=false;
            }
        }
        return flag;
    }

    @Override
    public boolean batchSaveAllotTime(List<TNcAllottime> tNcAllottimes) {
        boolean flag = true;
        for (TNcAllottime bean:tNcAllottimes){
            boolean b = ncAllottimeDao.saveAllottime(bean);
            if (b==false){
                flag=false;
            }
        }
        return flag;
    }

    @Override
    public Pagination getSystemCardList(String devname, String custname, String cardno, String syncstatus, String regionid, String allocatStartDate, String allocatEndDate, String operflag, int pageNo, int pageSize) {
        return ncCardListDao.getSystemCardList(devname, custname, cardno, syncstatus, regionid, allocatStartDate, allocatEndDate, operflag, pageNo, pageSize);
    }

    @Override
    public Pagination getOperatorCardList(String devname, String custname, String cardno, String syncstatus, String regionid, String allocatStartDate, String allocatEndDate, String operflag, int pageNo, int pageSize, String operRegionid) {
        return ncCardListDao.getOperatorCardList(devname, custname, cardno, syncstatus, regionid, allocatStartDate, allocatEndDate, operflag, pageNo, pageSize, operRegionid);
    }

    @Override
    public Pagination getBuildingOperCardList(String devname, String custname, String cardno, String syncstatus, String allocatStartDate, String allocatEndDate, String operflag, int pageNo, int pageSize, String operid) {
        return ncCardListDao.getBuildingOperCardList(devname, custname, cardno, syncstatus, allocatStartDate, allocatEndDate, operflag, pageNo, pageSize, operid);
    }

    @Override
    public TNcCardlist getNcCardlistById(String id) {
        return ncCardListDao.getNcCardlistById(id);
    }

    @Override
    public boolean updateNcCardlist(TNcCardlist bean) {
        return ncCardListDao.updateNcCardlist(bean);
    }

    @Override
    public void syncNcCardlistByCardnoAndStatus(String cardno, String status, String tranStatus) {
        String now = DateUtil.getNow();
        List<TNcCardlist> cardlistByCardno = ncCardListDao.getNcCardlistByCardno(cardno);
        //1.判断此卡是否被下发
        if (null == cardlistByCardno || cardlistByCardno.isEmpty()){
            return;
        }
        //2.判断下发状态，如果不一致则重新下发到设备
        for (TNcCardlist cardlist:cardlistByCardno) {
            String flagTmp = "D";
            if (status.equals("normal") && tranStatus.equals("normal")) {
                flagTmp = "A";
            }
            if (cardlist.getOperflag().equals(flagTmp)) {
                continue;
            }
            cardlist.setOperflag(flagTmp);
            cardlist.setRectime(now);
            cardlist.setVersion(cardlist.getVersion() + 1);
            cardlist.setSyncflag("N");
            cardlist.setSynctime("");
            ncCardListDao.updateNcCardlist(cardlist);
        }

    }
}
