package com.supwisdom.dlpay.framework.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.supwisdom.dlpay.api.bean.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.stereotype.Component;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Component("myInvalidSessionStrategy")
public class MyInvalidSessionStrategy implements InvalidSessionStrategy {
  @Autowired
  private ObjectMapper objectMapper = new ObjectMapper();

  @Override
  public void onInvalidSessionDetected(HttpServletRequest request, HttpServletResponse response)
      throws IOException, ServletException {
    JsonResult result =new JsonResult();
    result.setCode(401);
    result.setMessage("session已经失效了");
    response.setStatus(HttpStatus.OK.value());
    response.setContentType("application/json;charset=UTF-8");
    response.getWriter().write(objectMapper.writeValueAsString(result));
  }
}
