package com.supwisdom.dlpay.hk.common;

/**
 * 常量
 */
public interface Constant {

    /**
     * HK相关接口路径
     */

    //获取token
    static public final String TOKEN = "https://api2.hik-cloud.com/oauth/token";

    /******社区******/

    //新增社区
    static public final String ADD_COMMUNITIES = "https://api2.hik-cloud.com/api/v1/estate/system/communities";

    //删除社区  ---使用时调用delete 方式  路径后加上要删除社区ID
    static public final String DELETE_COMMUNITIES = "https://api2.hik-cloud.com/api/v1/estate/system/communities/";

    //修改社区
    static public final String UPDATE_COMMUNITIES = "https://api2.hik-cloud.com/api/v1/estate/system/communities/actions/updateCommunity";

    //查询此租户下所有社区
    static public final String COMMUNITIES_LIST = "https://api2.hik-cloud.com/api/v1/estate/system/communities/actions/list?pageNo=1&pageSize=10";


    /******房屋******/

    //新增楼栋
    static public final String ADD_BUILDINGS = "https://api2.hik-cloud.com/api/v1/estate/system/buildings";

    //新增单元
    static public final String ADD_UNITS = "https://api2.hik-cloud.com/api/v1/estate/system/units";

    //新增户室
    static public final String ADD_ROOMS = "https://api2.hik-cloud.com/api/v1/estate/system/rooms";

    //根据编号查询户室  路径后跟属性和参数
    static public final String FIND_ROOMS_BY_NUMBER = "https://api2.hik-cloud.com/v1/estate/system/rooms/actions/info";

    //根据户室ID查询户室  路径后跟属性和参数
    static public final String FIND_ROOMS_BY_ID = "https://api2.hik-cloud.com/api/v1/estate/system/rooms/actions/infoById";

    //删除楼栋  使用时调用delete方式   路径后跟楼栋ID
    static public final String DELETE_BUILDINGS = "https://api2.hik-cloud.com/api/v1/estate/system/buildings/";

    //删除单元  使用时调用delete方式   路径后跟单元ID
    static public final String DELETE_UNITS = "https://api2.hik-cloud.com/api/v1/estate/system/units/";

    //删除户室  使用时调用delete方式   路径后跟户室ID
    static public final String DELETE_ROOMS = "https://api2.hik-cloud.com/api/v1/estate/system/rooms/";


    /******人员******/

    //新增人员
    static public final String ADD_PERSON = "https://api2.hik-cloud.com/api/v1/estate/system/person";

    //删除人员  使用时调用delete方式   路径后跟人员ID
    static public final String DELETE_PERSON = "https://api2.hik-cloud.com/api/v1/estate/system/person/";

    //修改人员
    static public final String UPDATE_PERSON = "https://api2.hik-cloud.com/api/v1/estate/system/person/actions/updatePerson";

    //设置人员所属社区
    static public final String ADD_COMMUNITY_PERSON_RELATION = "https://api2.hik-cloud.com/api/v1/estate/system/person/actions/addCommunityRelation";

    //删除人员所属社区
    static public final String DELETE_COMMUNITY_PERSON_RELATION = "https://api2.hik-cloud.com/api/v1/estate/system/person/actions/deleteCommunityRelation";

    //设置人员所属户室
    static public final String ADD_ROOM_PERSON_RELATION = "https://api2.hik-cloud.com/api/v1/estate/system/person/actions/addRoomRelation";

    //删除人员所属户室
    static public final String DELETE_ROOM_PERSON_RELATION = "https://api2.hik-cloud.com/api/v1/estate/system/person/actions/deleteRoomRelation";

    //获取人员户室信息    路径后跟属性和参数
    static public final String FIND_PERSON_ROOMS = "https://api2.hik-cloud.com/api/v1/estate/system/person/actions/roomList";

    /******物业人员管理******/

    //新增物业管理人员
    static public final String ADD_PROPERTY_MANAGER = "https://api2.hik-cloud.com/api/v1/estate/system/property";

    //修改物业管理人员
    static public final String UPDATE_PROPERTY_MANAGER = "https://api2.hik-cloud.com/api/v1/estate/system/property/actions/updateProperty";

    //删除物业管理人员   使用时调用delete方式   路径后跟物业人员ID
    static public final String DELETE_PROPERTY_MANAGER = "https://api2.hik-cloud.com/api/v1/estate/system/property/";

    /******设备管理******/

    //查询社区下设备通道列表  路径后跟属性参数
    static public final String FIND_COMMUNITY_DEVICE = "https://api2.hik-cloud.com/api/v1/estate/devices/channels/actions/listByCommunityId";

    /******卡片管理******/

    //新增卡片(白卡)
    static public final String ADD_CARDS = "https://api2.hik-cloud.com/api/v1/estate/system/cards";

    //删除卡片(白卡)  使用时调用delete方式   路径后跟卡片ID
    static public final String DELETE_CARDS = "https://api2.hik-cloud.com/api/v1/estate/system/cards/";

    //开卡
    static public final String OPEN_CARD = "https://api2.hik-cloud.com/api/v1/estate/system/cards/actions/openCard";

    //退卡
    static public final String REFUND_CARD = "https://api2.hik-cloud.com /api/v1/estate/system/cards/actions/refundCard";

    //换卡
    static public final String CHANGE_CARD = "https://api2.hik-cloud.com/api/v1/estate/system/cards/actions/changeCard";

    //挂失卡
    static public final String LOSS_CARD = "https://api2.hik-cloud.com/api/v1/estate/system/cards/actions/lossCard";

    //解挂卡
    static public final String CANCEL_LOSS_CARD = "https://api2.hik-cloud.com/api/v1/estate/system/cards/actions/cancelLossCard";

    //补卡
    static public final String REISSUE_CARD = "https://api2.hik-cloud.com/api/v1/estate/system/cards/actions/reissueCard";

    /******门禁组件******/

    //获取人员门禁设备信息  路径后跟属性参数
    static public final String FIND_PERSON_REMOTE_DEVICE = "https://api2.hik-cloud.com/api/v1/estate/entranceGuard/remoteControl/actions/deviceList";

    /******人脸信息******/

    //人脸信息下发
    static public final String ISSUED_FACE = "https://api2.hik-cloud.com/api/v1/estate/entranceGuard/permissions/actions/faceIssued";

    //人脸信息删除
    static public final String DELETE_ISSUED_FACE = "https://api2.hik-cloud.com/api/v1/estate/entranceGuard/permissions/actions/deleteFaceIssued";

    /******远程控门******/

    //远程开门
    static public final String REMOTE_DOOR = "https://api2.hik-cloud.com/api/v1/estate/entranceGuard/remoteControl/actions/gateControl";

    /******动态密码******/

    //动态密码生成
    static public final String DYNAMIC_CODE = "https://api2.hik-cloud.com/api/v1/estate/entranceGuard/permissions/actions/dynamicCode";

    /******访客管理组件******/

    //访客登记
    static public final String ADD_VISITORS = "https://api2.hik-cloud.com/api/v1/estate/visitors";

    //访客删除  使用delete请求方式 后跟访客记录ID
    static public final String DELETET_VISITORS = "https://api2.hik-cloud.com/api/v1/estate/visitors/";

    /******消息管理组件******/

    //创建消费者
    static public final String ADD_CONSUMER = "https://api2.hik-cloud.com/api/v1/mq/consumer/group1";

    //消息信息
    static public final String CONSUME_MESSAGES = "https://api2.hik-cloud.com/api/v1/mq/consumer/messages";

    //提交偏移量
    static public final String COMMIT_OFFSETS = "https://api2.hik-cloud.com/api/v1/mq/consumer/offsets";

    /******第三方云眸平台跳转******/
    static public final String HIK_CLOUD_URL = "https://api2.hik-cloud.com";

}
