package com.supwisdom.dlpay.mainservice.dao.impl;

import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.mainservice.dao.CustomerDao;
import com.supwisdom.dlpay.mainservice.domain.TCustomer;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.List;

@Repository
public class CustomerDaoImpl implements CustomerDao {

    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public TCustomer findCustomerByNo(String cardno) {
        String sql = "select bean from TCustomer bean left join TCard a on a.custid= bean.custid " +
                " where a.cardno=:cardno ";
        TypedQuery<TCustomer> query = entityManager.createQuery(sql, TCustomer.class);
        query.setParameter("cardno", cardno);
        List<TCustomer> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public TCustomer findCustomerById(String custid) {
        String sql = "select bean from TCustomer bean where bean.custid=:custid";
        TypedQuery<TCustomer> query = entityManager.createQuery(sql, TCustomer.class);
        query.setParameter("custid", custid);
        List<TCustomer> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean saveCustomer(TCustomer bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public List<TCustomerInfo> getAllTCustomerList(String perName, String cardno, String bankcardno) {
        String sql = "select a.custid,a.custname,b.cardno,b.bankcardno,b.cardphyid,b.expiredate from T_Customer a left join t_card b on a.custid = b.custid " +
                " where a.status='1' and b.status='normal' and b.transtatus='normal' ";
        if (!StringUtil.isEmpty(perName)){
            sql += " and a.custname like :perName ";
        }
        if (!StringUtil.isEmpty(cardno)){
            sql +=" and b.cardno like :cardno ";
        }
        if (!StringUtil.isEmpty(bankcardno)){
            sql +=" and b.bankcardno like :bankcardno ";
        }
        sql +=" order by b.cardno desc ";
        Query query = entityManager.createNativeQuery(sql, TCustomerInfo.class);
        if (!StringUtil.isEmpty(perName)){
            query.setParameter("perName", "%"+perName+"%");
        }
        if (!StringUtil.isEmpty(cardno)){
            query.setParameter("cardno", cardno);
        }
        if (!StringUtil.isEmpty(bankcardno)){
            query.setParameter("bankcardno", bankcardno);
        }
        List<TCustomerInfo> list = query.getResultList();
        return list;
    }

    @Transactional
    @Override
    public TCustomerInfo getTCustomerByExcel(String cardno) {
        String sql = "select a.custid,a.custname,b.cardno,b.bankcardno,b.cardphyid,b.expiredate from t_customer a,t_card b  " +
                " where a.custid = b.custid and b.status = 'normal' and b.transtatus='normal' and cardno=?1 ";
        Query query = entityManager.createNativeQuery(sql, TCustomerInfo.class);
        query.setParameter(1, cardno);
        List<TCustomerInfo> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }
}
