package com.supwisdom.dlpay.ncmgr.dao.impl;

import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.ncmgr.dao.NcWeekTimeDao;
import com.supwisdom.dlpay.ncmgr.domain.TNcWeektime;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.List;

@Repository
public class NcWeekTimeDaoImpl implements NcWeekTimeDao {
    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public Pagination getNcWeekTimeWithPage(String time, int pageNo, int pageSize) {
        String sql = " select bean from TNcWeektime bean where 1>0 and bean.adddelflag=1 ";
        if (!StringUtil.isEmpty(time)){
            sql +=" and bean.weekname like :timename ";
        }
        TypedQuery<TNcWeektime> query = entityManager.createQuery(sql, TNcWeektime.class);
        if (!StringUtil.isEmpty(time)){
            query.setParameter("timename", "%"+time+"%");
        }

        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TNcWeektime> list = query.getResultList();
        page.setList(list);
        int totalCount = getNcWeekTimeCount(time);
        page.setTotalCount(totalCount);
        return page;
    }

    private int getNcWeekTimeCount(String time){
        String sql = "select count(bean.weekid) from TNcWeektime bean where 1>0 and bean.adddelflag=1 ";
        if (!StringUtil.isEmpty(time)){
            sql +=" and bean.weekname like :timename ";
        }
        Query query = entityManager.createQuery(sql);
        if (!StringUtil.isEmpty(time)){
            query.setParameter("timename", "%"+time+"%");
        }
        int cnt = 0;
        List list = query.getResultList();
        if (list!=null && list.size()>0){
            cnt = Integer.parseInt(list.get(0).toString());
        }
        return cnt;
    }

    @Transactional
    @Override
    public TNcWeektime findByWeekTimeId(int id) {
        String sql = "select r from TNcWeektime r where r.weekid=:id";
        TypedQuery<TNcWeektime> query = entityManager.createQuery(sql, TNcWeektime.class);
        query.setParameter("id", id);
        List<TNcWeektime> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public TNcWeektime findByWeekTimeName(String name) {
        String sql = " select r from TNcWeektime r where r.weekname=:name";
        TypedQuery<TNcWeektime> query = entityManager.createQuery(sql, TNcWeektime.class);
        query.setParameter("name", name);
        List<TNcWeektime> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public int getMaxWeekId() {
        String sql = "select max(r.weekid) from TNcWeektime r ";
        Query query = entityManager.createQuery(sql);
        Object result = query.getSingleResult();
        if (result!=null){
            return (int)result;
        }
        return 0;
    }

    @Transactional
    @Override
    public boolean saveWeektime(TNcWeektime bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public TNcWeektime findByWeekIdAndName(int id, String name) {
        String sql = "select bean from TNcWeektime bean where bean.weekname=?1 ";
        if (!StringUtil.isEmpty(name)) {
            sql += " and bean.weekid<>:timeid ";
        }
        TypedQuery<TNcWeektime> query = entityManager.createQuery(sql, TNcWeektime.class);
        query.setParameter(1, name);
        if (id!=0) {
            query.setParameter("timeid", id);
        }
        List<TNcWeektime> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean updateWeektime(TNcWeektime bean) {
        boolean flag = false;
        try {
            entityManager.merge(bean);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public List getDevWeekByWeekid(int id) {
        try{
            String sql = "select DEVID from T_NC_DEVWEEK t where weekid=?1";
            Query query = entityManager.createNativeQuery(sql);
            query.setParameter(1,id);
            List list = query.getResultList();
            return list;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    @Transactional
    @Override
    public boolean delByWeekId(int id) {
        boolean flag = false;
        try {
            String sql = "UPDATE T_NC_WEEKTIME SET ADDDELFLAG=0 where weekid=?1 ";
            Query query = entityManager.createNativeQuery(sql);
            query.setParameter(1, id);
            query.executeUpdate();
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public List<TNcWeektime> findAllNcWeekTime() {
        String sql = " select r from TNcWeektime r where r.adddelflag=1 order by r.weekid";
        TypedQuery<TNcWeektime> query = entityManager.createQuery(sql, TNcWeektime.class);
        List<TNcWeektime> list = query.getResultList();
        return list;
    }
}
