package com.supwisdom.dlpay.ncmgr.service.impl;

import com.supwisdom.dlpay.doorlist.bean.TDoordevInfo;
import com.supwisdom.dlpay.ncmgr.dao.*;
import com.supwisdom.dlpay.ncmgr.domain.*;
import com.supwisdom.dlpay.ncmgr.service.NcService;
import com.supwisdom.dlpay.system.domain.TRegion;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service
public class NcServiceImpl implements NcService {
    @Autowired
    private NcDeviceDao ncDeviceDao;
    @Autowired
    private NcCardListDao ncCardListDao;
    @Autowired
    private NcTimeDao ncTimeDao;
    @Autowired
    private NcDevWeekDao ncDevWeekDao;
    @Autowired
    private NcTimeGrpDao ncTimeGrpDao;
    @Autowired
    private NcWeekTimeDao ncWeekTimeDao;


    @Override
    public Pagination getSystemNcDeviceWithPage(String devname, int pageNo, int pageSize, Map map, String buildingid,String regionid, String devtype) {
        Pagination page = ncDeviceDao.getSystemNcDeviceWithPage(devname, pageNo, pageSize, buildingid,regionid, devtype);
        map.put("devPage", page);
        return page;
    }

    @Override
    public Pagination getOperatorNcDeviceWithPage(String devname, int pageNo, int pageSize, String buildingid, String regionid, String devtype,String operRegionid) {
        return ncDeviceDao.getOperatorNcDeviceWithPage(devname, pageNo, pageSize, buildingid, regionid, devtype,operRegionid);
    }

    @Override
    public Pagination getBuildingOperNcDeviceWithPage(String devname, int pageNo, int pageSize, String buildingid, String devtype,String operid) {
        return ncDeviceDao.getBuildingOperNcDeviceWithPage(devname, pageNo, pageSize, buildingid, devtype, operid);
    }

    @Override
    public List<TBuilding> getAllBuilding() {
        return ncDeviceDao.getAllBuilding();
    }

    @Override
    public List<TRegion> getAllRegion() {
        return ncDeviceDao.getAllRegion();
    }

    @Override
    public TBuilding getBuidingById(String id) {
        return ncDeviceDao.getBuidingById(id);
    }

    @Override
    public List<TNcDevice> getSystemDevByType(String type) {
        return ncDeviceDao.getSystemDevByType(type);
    }

    @Override
    public List<TNcDevice> getOperatorDevByType(String type,String regionid) {
        return ncDeviceDao.getOperatorDevByType(type,regionid);
    }

    @Override
    public List<TNcDevice> getBuildingOperDevByType(String type, String operid) {
        return ncDeviceDao.getBuildingOperDevByType(type, operid);
    }

    @Override
    public TNcDevice findDevById(int id) {
        return ncDeviceDao.findDevById(id);
    }

    @Override
    public TNcDevice validDevName(int devid, String devname) {
        return ncDeviceDao.validDevName(devid, devname);
    }

    @Override
    public TNcDevice validDevPhyid(int devid, String devPhyid) {
        return ncDeviceDao.validDevPhyid(devid, devPhyid);
    }

    @Override
    public TNcDevice validDevNo(int fdevid, int devno, int devid) {
        return ncDeviceDao.validDevNo(fdevid, devno, devid);
    }

    @Override
    public boolean updateDevice(TNcDevice bean) {
        return ncDeviceDao.updateDevice(bean);
    }

    @Override
    public int getMaxId() {
        return ncDeviceDao.getMaxId();
    }

    @Override
    public boolean saveDevice(TNcDevice bean) {
        return ncDeviceDao.saveDevice(bean);
    }

    @Override
    public TNcDevice getDevInfoByDevid(int devid) {
        return ncDeviceDao.getDevInfoByDevid(devid);
    }

    @Override
    public List<TNcDevice> getDevListByfDevid(int devid) {
        return ncDeviceDao.getDevListByfDevid(devid);
    }

    @Override
    public void delDevById(int devid) {
        ncDeviceDao.updateTodelDevById(devid);
    }

    @Override
    public void updateBuildingnameByBuildingid(String buildingid, String buildingname) {
        ncDeviceDao.updateBuildingnameByBuildingid(buildingid, buildingname);
    }

    @Override
    public boolean getDevWeekByDevid(int devid) {
        return ncDevWeekDao.getDevWeekByDevid(devid);
    }

    @Override
    public TNcCardlist getCleanList(int devid) {
        return ncCardListDao.getCleanList(devid);
    }

    @Override
    public boolean saveCardlist(TNcCardlist bean) {
        return ncCardListDao.saveCardlist(bean);
    }

    @Override
    public boolean updateCardlist(TNcCardlist bean) {
        return ncCardListDao.updateCardlist(bean);
    }

    @Override
    public void updateForListReload(int devid) {
        ncCardListDao.updateForListReload(devid);
    }

    @Override
    public TNcDevice getDevByBuildingid(String buildingid) {
        return ncDeviceDao.getDevByBuildingid(buildingid);
    }

    @Override
    public List<TDoordevInfo> getSystemDevList(String devname,String regionid,String buildingid) {
        return ncDeviceDao.getSystemDevList(devname,regionid,buildingid);
    }

    @Override
    public List<TDoordevInfo> getOperatorDevList(String devname,String regionid,String buildingid,String operRegionid) {
        return ncDeviceDao.getOperatorDevList(devname,regionid,buildingid,operRegionid);
    }

    @Override
    public List<TDoordevInfo> getBuildingOperDevList(String devname,String regionid,String buildingid,String operid) {
        return ncDeviceDao.getBuildingOperDevList(devname,regionid,buildingid,operid);
    }

    @Override
    public Pagination getNcTimeWithPage(String time, int pageNo, int pageSize,Map map) {
        Pagination page = ncTimeDao.getNcTimeWithPage(time, pageNo, pageSize);
        map.put("timePage", page);
        return page;
    }

    @Override
    public List<String> getTimegrpIdById(int id) {
        return ncTimeDao.getTimegrpIdById(id);
    }

    @Override
    public boolean delTimeByTimeId(int id) {
        return ncTimeDao.delTimeByTimeId(id);
    }

    @Override
    public boolean updListVersion() {
        return ncDevWeekDao.updListVersion();
    }

    @Override
    public TNcTime findByTimeId(int id) {
        return ncTimeDao.findByTimeId(id);
    }

    @Override
    public TNcTime findByTimeName(String name) {
        return ncTimeDao.findByTimeName(name);
    }

    @Override
    public int getMaxTimeId() {
        return ncTimeDao.getMaxTimeId();
    }

    @Override
    public boolean saveTime(TNcTime bean) {
        return ncTimeDao.saveTime(bean);
    }

    @Override
    public TNcTime findByIdAndName(int id, String name) {
        return ncTimeDao.findByIdAndName(id, name);
    }

    @Override
    public boolean updateTime(TNcTime bean) {
        return ncTimeDao.updateTime(bean);
    }

    @Override
    public Pagination getNcTimeGrpWithPage(String time, int pageNo, int pageSize, Map map) {
        Pagination page = ncTimeGrpDao.getNcTimeGrpWithPage(time, pageNo, pageSize);
        map.put("timeGrpPage", page);
        return page;
    }

    @Override
    public List<TNcTime> findAllNcTime() {
        return ncTimeDao.findAllNcTime();
    }

    @Override
    public TNcTimegrp findByTimeGrpId(int id) {
        return ncTimeGrpDao.findByTimeGrpId(id);
    }

    @Override
    public TNcTimegrp findByTimeGrpName(String name) {
        return ncTimeGrpDao.findByTimeGrpName(name);
    }

    @Override
    public int getMaxTimeGrpId() {
        return ncTimeGrpDao.getMaxTimeGrpId();
    }

    @Override
    public boolean saveTimegrp(TNcTimegrp bean) {
        return ncTimeGrpDao.saveTimegrp(bean);
    }

    @Override
    public TNcTimegrp findByGrpIdAndName(int id, String name) {
        return ncTimeGrpDao.findByGrpIdAndName(id, name);
    }

    @Override
    public boolean updateTimegrp(TNcTimegrp bean) {
        return ncTimeGrpDao.updateTimegrp(bean);
    }

    @Override
    public List<String> getWeekTimeById(int id) {
        return ncTimeGrpDao.getWeekTimeById(id);
    }

    @Override
    public boolean delByGrpId(int id) {
        return ncTimeGrpDao.delByGrpId(id);
    }

    @Override
    public Pagination getNcWeekTimeWithPage(String time, int pageNo, int pageSize, Map map) {
        Pagination page = ncWeekTimeDao.getNcWeekTimeWithPage(time, pageNo, pageSize);
        map.put("weekTimePage", page);
        return page;
    }

    @Override
    public List<TNcTimegrp> findAllNcTimeGrp() {
        return ncTimeGrpDao.findAllNcTimeGrp();
    }

    @Override
    public TNcWeektime findByWeekTimeId(int id) {
        return ncWeekTimeDao.findByWeekTimeId(id);
    }

    @Override
    public TNcWeektime findByWeekTimeName(String name) {
        return ncWeekTimeDao.findByWeekTimeName(name);
    }

    @Override
    public int getMaxWeekId() {
        return ncWeekTimeDao.getMaxWeekId();
    }

    @Override
    public boolean saveWeektime(TNcWeektime bean) {
        return ncWeekTimeDao.saveWeektime(bean);
    }

    @Override
    public TNcWeektime findByWeekIdAndName(int id, String name) {
        return ncWeekTimeDao.findByWeekIdAndName(id, name);
    }

    @Override
    public boolean updateWeektime(TNcWeektime bean) {
        return ncWeekTimeDao.updateWeektime(bean);
    }

    @Override
    public List getDevWeekByWeekid(int id) {
        return ncWeekTimeDao.getDevWeekByWeekid(id);
    }

    @Override
    public boolean delByWeekId(int id) {
        return ncWeekTimeDao.delByWeekId(id);
    }

    @Override
    public Pagination getNcDevWeekWithPage(int weekid, String devname, int pageNo, int pageSize, Map map) {
        Pagination page = ncDevWeekDao.getNcDevWeekWithPage(weekid, devname, pageNo, pageSize);
        map.put("devWeekPage", page);
        return page;
    }

    @Override
    public List<TNcWeektime> findAllNcWeekTime() {
        return ncWeekTimeDao.findAllNcWeekTime();
    }

    @Override
    public void delDevWeekById(int devid, int weekid) {
        ncDevWeekDao.delDevWeekById(devid, weekid);
    }

    @Override
    public int findMaxDevWeekVersion() {
        return ncDevWeekDao.findMaxDevWeekVersion();
    }

    @Override
    public void deleteDevWeekByWeekId(int weekId) {
        ncDevWeekDao.deleteDevWeekByWeekId(weekId);
    }

    @Override
    public boolean saveDevWeek(TNcDevweek devweek) {
        return ncDevWeekDao.saveDevWeek(devweek);
    }

    @Override
    public List<TNcDevweek> findChosenDev(int weekId) {
        return ncDevWeekDao.findChosenDev(weekId);
    }

    @Override
    public List<TNcDevice> findAllNcDevices() {
        return ncDeviceDao.findAllNcDevices();
    }

    @Override
    public List<TNcDevice> findOperatorDevices(String operRegionid) {
        return ncDeviceDao.findOperatorDevices(operRegionid);
    }

    @Override
    public Pagination getAllRemoteDev(String devname, int pageNo, int pageSize, String buildingid, String regionid) {
        return ncDeviceDao.getAllRemoteDev(devname, pageNo, pageSize, buildingid, regionid);
    }

    @Override
    public Pagination getOperateRemoteDev(String devname, int pageNo, int pageSize, String buildingid, String regionid, String operRegionid) {
        return ncDeviceDao.getOperateRemoteDev(devname, pageNo, pageSize, buildingid, regionid, operRegionid);
    }

    @Override
    public Pagination getBuildingOperRemoteDev(String devname, int pageNo, int pageSize, String buildingid, String regionid, String operid) {
        return ncDeviceDao.getBuildingOperRemoteDev(devname, pageNo, pageSize, buildingid, regionid, operid);
    }
}
