package com.supwisdom.dlpay.system.controller;

import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.system.bean.CompanyBean;
import com.supwisdom.dlpay.system.bean.CompanyCheckBean;
import com.supwisdom.dlpay.system.bean.CompanyCheckMessageBean;
import com.supwisdom.dlpay.system.domain.TCompany;
import com.supwisdom.dlpay.system.domain.TDictionaryId;
import com.supwisdom.dlpay.system.domain.TModifyCompany;
import com.supwisdom.dlpay.system.page.Pagination;
import com.supwisdom.dlpay.system.service.CompanyService;
import com.supwisdom.dlpay.system.service.SystemService;
import com.supwisdom.dlpay.util.RedisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/company")
public class CompanyController {
    protected static Logger logger = LoggerFactory.getLogger(CompanyController.class);

    @Autowired
    CompanyService companyService;
    @Autowired
    SystemService systemService;

    @RequestMapping("/companyindex")
    public String companyindex(ModelMap model) {
        return "system/company";
    }

    @RequestMapping("/companycheckindex")
    public String companycheckindex(){
        return "system/companyCheck";
    }


    /**
     * 分页获取所有公司信息，或者自身所属公司信息
     *
     * @param pageNo
     * @param pageSize
     * @param companyName
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping("/loadCompanyList")
    public Map loadCompanyList(@RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                               @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
                               @RequestParam(value = "companyName", required = false, defaultValue = "") String companyName,
                               @AuthenticationPrincipal TOperator operUser) {
        Map map = new HashMap();
        try {
            String opertype = operUser.getOpertype();
            Pagination page = null;
            if (!StringUtil.isEmpty(opertype) && (opertype.equals("S") || opertype.equals("P"))) {
                page = companyService.getSystemCompanyList(companyName, pageNo, pageSize);
            } else {
                page = companyService.getOperCompanyList(companyName, pageNo, pageSize, operUser.getOperid());
            }
            map.put("PageResult", page);
            map.put("opertype", operUser.getOpertype());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    /**
     * 保存公司信息
     *
     * @param postData
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/addCompany", method = {RequestMethod.POST})
    public Map addCompany(@RequestBody CompanyBean postData) {
        Map map = new HashMap();
        try {
            TCompany companyByName = companyService.getCompanyByName(postData.getCompanyName());
            if (companyByName != null) {
                map.put("errStr", "公司名称已经存在，请修改！");
                return map;
            }
            TCompany company = new TCompany();
            long companyId = RedisUtil.incr("seq_company");
            company.setCompanyId(companyId + "");
            company.setCompanyName(postData.getCompanyName());
            company.setLicenseId(postData.getLicenseId());
            company.setCompanyAddress(postData.getCompanyAddress());
            company.setLegalPeople(postData.getLegalPeople());
            company.setLegalPeopleCardType(postData.getLegalPeopleCardType());
            company.setLegalPeopleCardId(postData.getLegalPeopleCardId());
            company.setCompanyPhone(postData.getCompanyPhone());
            company.setRemarks(postData.getRemarks());
            //新注册公司需要审核  ---status设为2 checkFlag为0 注册
            company.setStatus("2");
            company.setCheckFlag("0");//审核注册
            company.setCheckStatus("0");//待审核

            companyService.saveCompany(company);
            map.put("errStr", "");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr", "保存公司失败!");
        }
        return map;
    }


    /**
     * 修改公司信息
     *
     * @param postData
     * @return
     */
    @RequestMapping(value = "/updateCompany", method = {RequestMethod.POST})
    @ResponseBody
    public Map updateRegion(@RequestBody CompanyBean postData) {
        Map map = new HashMap();
        try {
            if (postData == null) {
                map.put("errStr", "请先选择公司，然后再修改！");
                return map;
            }
            TCompany companyByName = companyService.getCompanyByNameAndId(postData.getCompanyName(), postData.getCompanyId());
            //需判断该名字在修改临时表中是否存在有效数据
            TModifyCompany modifyCompanyByNameAndId = companyService.getModifyCompanyByNameAndId(postData.getCompanyName(), postData.getCompanyId());
            if (companyByName != null || modifyCompanyByNameAndId!=null) {
                map.put("errStr", "公司名称已经存在，请修改！");
                return map;
            }


            TCompany company = companyService.getCompanyAllStatusById(postData.getCompanyId());
            if (company==null){
                map.put("errStr", "该公司不存在！");
                return map;
            }
            //将修改信息暂存放到TB_Modify_Company 表中 审核通过后正式使用
            TModifyCompany tModifyCompany = null;
            tModifyCompany = companyService.getModifyCompanyById(company.getCompanyId());
            if (tModifyCompany == null) {
                tModifyCompany = new TModifyCompany();
                tModifyCompany.setCompanyId(company.getCompanyId());
                tModifyCompany.setCompanyName(postData.getCompanyName());
                tModifyCompany.setLicenseId(postData.getLicenseId());
                tModifyCompany.setCompanyAddress(postData.getCompanyAddress());
                tModifyCompany.setLegalPeople(postData.getLegalPeople());
                tModifyCompany.setLegalPeopleCardType(postData.getLegalPeopleCardType());
                tModifyCompany.setLegalPeopleCardId(postData.getLegalPeopleCardId());
                tModifyCompany.setCompanyPhone(postData.getCompanyPhone());
                tModifyCompany.setRemarks(postData.getRemarks());
                tModifyCompany.setStatus("1");//有效
            }else {
                tModifyCompany.setCompanyName(postData.getCompanyName());
                tModifyCompany.setLicenseId(postData.getLicenseId());
                tModifyCompany.setCompanyAddress(postData.getCompanyAddress());
                tModifyCompany.setLegalPeople(postData.getLegalPeople());
                tModifyCompany.setLegalPeopleCardType(postData.getLegalPeopleCardType());
                tModifyCompany.setLegalPeopleCardId(postData.getLegalPeopleCardId());
                tModifyCompany.setCompanyPhone(postData.getCompanyPhone());
                tModifyCompany.setRemarks(postData.getRemarks());
                tModifyCompany.setStatus("1");//有效
            }
            companyService.saveModifyCompany(tModifyCompany);

            //修改时 公司状态为原始状态 审核失败后返回原始状态

            //编辑时,如公司原来注册审核未通过，则审核标志依然为注册--0
            if (!company.getCheckFlag().equals("0")){
                company.setCheckFlag("1");//审核修改
            }

            company.setCheckStatus("0");//待审核
            //上次审核结果置为空
            company.setCheckMessage("");

            companyService.updateCompany(company);

            map.put("errStr", "");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr", "公司修改失败!");
        }
        return map;
    }


    /**
     * 删除公司
     *
     * @param companyId
     * @return
     */
    @RequestMapping("/deleteCompany")
    @ResponseBody
    public Map deleteCompany(@RequestParam(value = "companyId") String companyId,
                             @AuthenticationPrincipal TOperator operUser) {
        Map map = new HashMap();
        String message = "";
        try {
            if (operUser.getOpertype().equals("L") || operUser.getOpertype().equals("H")){
                message="权限不足，请联系管理员！";
                map.put("message", message);
                return map;
            }

            List<TOperator> operByCompanyId = companyService.getOperByCompanyId(companyId);
            if (operByCompanyId != null && operByCompanyId.size() > 0) {
                message = "此公司已被绑定!";
                map.put("message", message);
                return map;
            }
            TCompany company = companyService.getCompanyAllStatusById(companyId);
            //公司删除 需进行审核

            company.setCheckFlag("2");//审核删除
            company.setCheckStatus("0");//待审核
            company.setCheckMessage("");//上次审核结果置为空

            companyService.updateCompany(company);

        } catch (Exception e) {
            e.printStackTrace();
            message = "删除公司出错!";
        }
        map.put("message", message);
        return map;
    }


    /**
     * 加载相应公司信息
     *
     * @param companyId
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping("/loadCompanyForUpdate")
    public Map loadCompanyForUpdate(@RequestParam(value = "companyId") String companyId,
                                    @AuthenticationPrincipal TOperator operUser) {
        Map map = new HashMap();
        String message="";
        try {
            if (operUser.getOpertype().equals("L") || operUser.getOpertype().equals("H")){
                message="权限不足，请联系管理员！";
                map.put("message", message);
                return map;
            }
            TCompany company = companyService.getCompanyAllStatusById(companyId);
            map.put("company", company);
            List<TDictionaryId> dicts = systemService.findTDictionaryByType(30);//法定代表人证件类型
            map.put("dicts", dicts);
            map.put("message", message);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }


    /**
     * 分页获取需要审核的公司信息
     *
     * @param pageNo
     * @param pageSize
     * @param companyName
     * @return
     */
    @ResponseBody
    @RequestMapping("/loadCompanyCheckList")
    public Map loadCompanyCheckList(@RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                                    @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
                                    @RequestParam(value = "companyName", required = false, defaultValue = "") String companyName) {
        Map map = new HashMap();
        try {
            Pagination page = null;
            page = companyService.getCheckCompanyList(companyName, pageNo, pageSize);
            map.put("PageResult", page);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    /**
     * 公司审核通过
     *
     * @param companyId
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping("/checkPass")
    public Map checkPass(@RequestParam(value = "companyId") String companyId,
                         @AuthenticationPrincipal TOperator operUser) {
        Map map = new HashMap();
        try {
            //审核通过实质 修改公司状态为有效--1,审核状态为通过--1,审核标志为空
            String message = "";
            TCompany company = companyService.getCompanyAllStatusById(companyId);
            if (company == null){
                message="该公司不存在！";
                map.put("message", message);
                return map;
            }

            if (!company.getCheckStatus().equals("0") && !company.getStatus().equals("2")) {
                message = "该公司不需要审核！";
                map.put("message", message);
                return map;
            }
            //判断公司审核标志是否为删除
            if (company.getCheckFlag().equals("2")){
                company.setStatus("0");//删除是置为注销状态---0
            }else {
                company.setStatus("1");
            }

            //当公司审核标志为修改时 需将TB_Modify_Company 表中公司信息作为修改后公司信息
            if (company.getCheckFlag().equals("1")){
                TModifyCompany tModifyCompany = companyService.getModifyCompanyById(companyId);
                company.setCompanyName(tModifyCompany.getCompanyName());
                company.setCompanyAddress(tModifyCompany.getCompanyAddress());
                company.setLicenseId(tModifyCompany.getLicenseId());
                company.setLegalPeople(tModifyCompany.getLegalPeople());
                company.setLegalPeopleCardType(tModifyCompany.getLegalPeopleCardType());
                company.setLegalPeopleCardId(tModifyCompany.getLegalPeopleCardId());
                company.setCompanyPhone(tModifyCompany.getCompanyPhone());
                company.setRemarks(tModifyCompany.getRemarks());


                tModifyCompany.setStatus("0");
                companyService.updateModifyCompany(tModifyCompany);//将修改临时信息置为无效
            }


            company.setCheckStatus("1");
            company.setCheckFlag("");
            company.setCheckMessage("");
            company.setCheckOperId(operUser.getOperid());

            companyService.updateCompany(company);

            map.put("message", message);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    /**
     * 批量通过审核公司
     *
     * @param companyCheckBeans
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/batchCheckPass", method = {RequestMethod.POST})
    public Map batchCheckPass(
            @RequestBody CompanyCheckBean[] companyCheckBeans,
            @AuthenticationPrincipal TOperator operUser) {
        Map map = new HashMap();
        try {
            for (CompanyCheckBean checkBean : companyCheckBeans) {
                String companyId = checkBean.getCompanyId();
                TCompany company = companyService.getCheckCompanyById(companyId);
                if (company != null) {
                    //判断公司审核标志是否未删除
                    if (company.getCheckFlag().equals("2")){
                        company.setStatus("0");//删除是置为注销状态---0
                    }else {
                        company.setStatus("1");
                    }

                    //当公司审核标志为修改时 需将TB_Modify_Company 表中公司信息作为修改后公司信息
                    if (company.getCheckFlag().equals("1")){
                        TModifyCompany tModifyCompany = companyService.getModifyCompanyById(companyId);
                        company.setCompanyName(tModifyCompany.getCompanyName());
                        company.setCompanyAddress(tModifyCompany.getCompanyAddress());
                        company.setLicenseId(tModifyCompany.getLicenseId());
                        company.setLegalPeople(tModifyCompany.getLegalPeople());
                        company.setLegalPeopleCardType(tModifyCompany.getLegalPeopleCardType());
                        company.setLegalPeopleCardId(tModifyCompany.getLegalPeopleCardId());
                        company.setCompanyPhone(tModifyCompany.getCompanyPhone());
                        company.setRemarks(tModifyCompany.getRemarks());


                        tModifyCompany.setStatus("0");
                        companyService.updateModifyCompany(tModifyCompany);//将修改临时信息置为无效
                    }

                    company.setCheckStatus("1");
                    company.setCheckFlag("");
                    company.setCheckMessage("");
                    company.setCheckOperId(operUser.getOperid());
                    companyService.updateCompany(company);
                }
            }
            map.put("result", "批量审核公司通过成功！");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("result", "批量审核公司通过失败！");
            logger.error("批量审核公司通过失败：" + e.getMessage());
        }
        return map;
    }


    /**
     * 公司审核驳回
     *
     * @param postData
     * @param operUser
     * @return
     */
    @RequestMapping(value = "/checkFail", method = {RequestMethod.POST})
    @ResponseBody
    public Map checkFail(@RequestBody CompanyCheckMessageBean postData,
                         @AuthenticationPrincipal TOperator operUser) {
        Map map = new HashMap();
        try {
            if (postData == null) {
                map.put("errStr", "请先选择公司，然后再进行审核！");
                return map;
            }
            TCompany company = companyService.getCheckCompanyById(postData.getCompanyId());
            if (company == null) {
                map.put("errStr", "该公司不需要审核或不存在！");
                return map;
            }
            //审核驳回实质 返回公司原状态 审核状态为驳回--2,审核标志为空
            company.setCheckStatus("2");
            //如果审核标志为注册 则驳回是 标志不置空
            if (!company.getCheckFlag().equals("0")) {
                company.setCheckFlag("");
            }

            //当公司审核标志为修改时 驳回需将TB_Modify_Company 表中公司信息置为无效
            if (company.getCheckFlag().equals("1")){
                TModifyCompany tModifyCompany = companyService.getModifyCompanyById(postData.getCompanyId());

                tModifyCompany.setStatus("0");
                companyService.updateModifyCompany(tModifyCompany);//将修改临时信息置为无效
            }

            company.setCheckMessage(postData.getCheckMessage());
            company.setCheckOperId(operUser.getOperid());

            companyService.updateCompany(company);

            map.put("errStr", "");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr", "公司审核驳回失败!");
        }
        return map;
    }


    /**
     * 批量驳回公司审核
     *
     * @param companyCheckBeans
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/batchCheckFail", method = {RequestMethod.POST})
    public Map batchCheckFail(
            @RequestBody CompanyCheckBean[] companyCheckBeans,
            @AuthenticationPrincipal TOperator operUser) {
        Map map = new HashMap();
        try {
            for (CompanyCheckBean checkBean : companyCheckBeans) {
                String companyId = checkBean.getCompanyId();
                TCompany company = companyService.getCheckCompanyById(companyId);
                if (company != null) {
                    company.setCheckStatus("2");
                    //如果审核标志为注册 则驳回是 标志不置空
                    if (!company.getCheckFlag().equals("0")) {
                        company.setCheckFlag("");
                    }

                    //当公司审核标志为修改时 驳回需将TB_Modify_Company 表中公司信息置为无效
                    if (company.getCheckFlag().equals("1")){
                        TModifyCompany tModifyCompany = companyService.getModifyCompanyById(companyId);

                        tModifyCompany.setStatus("0");
                        companyService.updateModifyCompany(tModifyCompany);//将修改临时信息置为无效
                    }

                    //批量驳回的审核结果都设为---批量驳回
                    company.setCheckMessage("批量驳回");
                    company.setCheckOperId(operUser.getOperid());
                    companyService.updateCompany(company);
                }
            }
            map.put("result", "批量审核公司成功！");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("result", "批量审核公司失败！");
            logger.error("批量审核公司失败：" + e.getMessage());
        }
        return map;
    }



    @ResponseBody
    @RequestMapping("/getCheckDetails")
    public Map getCheckDetails(@RequestParam(value = "companyId") String companyId,
                                    @AuthenticationPrincipal TOperator operUser) {
        Map map = new HashMap();
        try {
            TCompany oldCompany = companyService.getCompanyAllStatusById(companyId);
            map.put("oldCompany", oldCompany);
            List<TDictionaryId> dicts = systemService.findTDictionaryByType(30);//法定代表人证件类型
            map.put("dicts", dicts);
            TModifyCompany newCompany = companyService.getModifyCompanyById(companyId);
            map.put("newCompany", newCompany);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }



}
