package com.supwisdom.dlpay.system.controller;


import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.framework.domain.TFunction;
import com.supwisdom.dlpay.framework.domain.TResource;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.WebConstant;
import com.supwisdom.dlpay.system.bean.FunctionSearchBean;
import com.supwisdom.dlpay.system.service.FunctionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Controller
public class FunctionController {

    @Autowired
    private FunctionService functionService;

    @GetMapping("/function/index")
    public String indexView() {
        return "system/function/index";
    }

    @GetMapping("/function/list")
    //@PreAuthorize("hasPermission('/function/index','')")
    @ResponseBody
    public PageResult<TFunction> getDataList(@RequestParam("page") Integer pageNo,
                                             @RequestParam("limit") Integer pageSize,
                                             @RequestParam(value = "searchkey", required = false) String searchKey) {
        try {
            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
            FunctionSearchBean searchBean = new FunctionSearchBean();
            searchBean.setPageNo(pageNo);
            searchBean.setFunctioname(searchKey);
            searchBean.setPageSize(pageSize);
            return functionService.getFunctionsByKey(searchBean);
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }

    @GetMapping("/function/loadadd")
    //@PreAuthorize("hasPermission('/function/loadadd','')")
    public String loadadd() {
        return "system/function/form";
    }

    @PostMapping("/function/add")
    //@PreAuthorize("hasPermission('/function/add','')")
    @ResponseBody
    public JsonResult add(@RequestBody TFunction function) {
        if (function != null) {
            return functionService.saveFunction(function);
        } else {
            return JsonResult.error("添加失败");
        }
    }
    @PostMapping("/function/delfunc")
    //@PreAuthorize("hasPermission('/function/delfunc','')")
    @ResponseBody
    public JsonResult delfunc(@RequestParam Integer funcid) {
        return functionService.deleteFunction(funcid);
    }

    @GetMapping("/function/checkname")
    @ResponseBody
    public JsonResult checkname(@RequestParam String name,
                                @RequestParam(value = "id", required = false) Integer id) {
        TFunction function = functionService.getFunctionByNameAndId(name, id);
        if (function == null) {
            return JsonResult.ok();
        } else {
            return JsonResult.error("功能名称重复");
        }
    }

    @GetMapping("/function/loadsubadd")
    //@PreAuthorize("hasPermission('/function/loadsubadd','')")
    public String loadsubadd(Model model) {
        List<TFunction> functionList = functionService.getParentFunction();
        model.addAttribute("list", functionList);
        return "system/function/subform";
    }

    @GetMapping("/function/loadres")
    //@PreAuthorize("hasPermission('/function/loadres','')")
    public String loadres(@RequestParam Integer functionid, Model model) {
        TFunction function = functionService.getFunctionById(functionid);
        List<TResource> resources = functionService.getResources(functionid);
        model.addAttribute("function", function);
        model.addAttribute("resources", resources);
        return "system/function/reslist";
    }
    @GetMapping("/function/reslist")
    //@PreAuthorize("hasPermission('/function/loadres','')")
    @ResponseBody
    public PageResult<TResource> reslist(@RequestParam Integer functionid, Model model) {
        List<TResource> resources = functionService.getResources(functionid);
        return new PageResult<TResource>(resources);
    }
    @GetMapping("/function/loadresadd")
    public String loadresadd(Model model) {
        List<TFunction> functionList = functionService.getLeafFunction();
        model.addAttribute("list", functionList);
        return "system/function/resform";
    }

    @PostMapping("/function/addres")
    //@PreAuthorize("hasPermission('/function/addres','')")
    @ResponseBody
    public JsonResult addres(@RequestBody TResource resource) {
        if (resource != null) {
            return functionService.saveRes(resource);
        } else {
            return JsonResult.error("添加失败");
        }
    }
    @GetMapping("/function/editres")
    public String loadresadd(@RequestParam Integer resid,Model model) {
        List<TFunction> functionList = functionService.getLeafFunction();
        model.addAttribute("list", functionList);
        return "system/function/resform";
    }
    @PostMapping("/function/delres")
    //@PreAuthorize("hasPermission('/function/delres','')")
    @ResponseBody
    public JsonResult delres(@RequestParam Integer resid) {
        return functionService.deleteResource(resid);
    }
}
