package com.supwisdom.dlpay.system.controller;

import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.framework.domain.*;
import com.supwisdom.dlpay.framework.security.OperUtil;
import com.supwisdom.dlpay.framework.util.*;
import com.supwisdom.dlpay.system.bean.FunctionSearchBean;
import com.supwisdom.dlpay.system.bean.LogBean;
import com.supwisdom.dlpay.system.bean.OperatorBean;
import com.supwisdom.dlpay.system.bean.OperatorSearchBean;
import com.supwisdom.dlpay.system.domain.TCompany;
import com.supwisdom.dlpay.system.domain.TDictionaryId;
import com.supwisdom.dlpay.system.domain.TRegion;
import com.supwisdom.dlpay.system.page.Pagination;
import com.supwisdom.dlpay.system.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Controller
@RequestMapping("/operator")
public class OperatorController {
    @Autowired
    private OperatorService operatorService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private CompanyService companyService;

    @GetMapping("/index")
    //@PreAuthorize("hasPermission('/operator/index','')")
    public String indexView(Model model) {
        return "system/operator/index";
    }

    @GetMapping("/list")
    @ResponseBody
    public PageResult<TOperator> getDataList(@RequestParam("page") Integer pageNo,
                                             @RequestParam("limit") Integer pageSize,
                                             @RequestParam(value = "searchkey", required = false) String searchKey,
                                             @RequestParam(value = "searchvalue", required = false) String searchValue) {
        try {

            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
            OperatorSearchBean searchBean = new OperatorSearchBean();
            if (!StringUtil.isEmpty(searchValue)) {
                if ("opercode".equals(searchKey)) {
                    searchBean.setOpercode(searchValue.trim());
                } else if ("opername".equals(searchKey)) {
                    searchBean.setOpername(searchValue.trim());
                } else if ("mobile".equals(searchValue.trim())) {
                    searchBean.setMobile(searchValue.trim());
                }
            }
            return operatorService.getOperatorsByPage(pageNo, pageSize, searchBean);
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }

    @GetMapping("/load4add")
    //@PreAuthorize("hasPermission('/operator/load4add','')")
    public String load4addOperator(Model model) {
        model.addAttribute("roles", roleService.findAllRoles());
        return "system/operator/operator";
    }

    @GetMapping("/checkopercode")
    @ResponseBody
    public JsonResult checkOpercode(@RequestParam("opercode") String opercode,
                                    @RequestParam(value = "operid", required = false) String operid) {
        if (operatorService.checkOpercodeExists(opercode, operid)) {
            return JsonResult.error("账号重复");
        }
        return JsonResult.ok("success");
    }

    @PostMapping("/getoperatorrole")
    @ResponseBody
    public JsonResult getoperatorrole(@RequestParam(value = "operid") String operid) {
        List<TOperRole> roles = operatorService.getOperRoleByOperId(operid);
        JsonResult ret = JsonResult.ok("success");
        ret.put("roles", roles);
        return ret;
    }

    @PostMapping("/add")
    //@PreAuthorize("hasPermission('/operator/add','')")
    @ResponseBody
    public JsonResult add(@RequestParam("operid") String operid, @RequestParam("opercode") String opercode,
                          @RequestParam("opername") String opername, @RequestParam("sex") String sex,
                          @RequestParam("mobile") String mobile, @RequestParam("email") String email,
                          @RequestParam("roleId") String roleId, Model map) {
        if (operatorService.checkOpercodeExists(opercode, operid)) {
            return JsonResult.error("账号重复");
        }
        TOperator operator = new TOperator();
        operator.setOpername(opername);
        operator.setOpercode(opercode);
        operator.setOperid(operid);
        operator.setMobile(mobile);
        operator.setEmail(email);
        operator.setSex(sex);
        boolean ret = operatorService.saveOperator(operator, roleId);
        if (ret) {
            return JsonResult.ok("操作成功");
        } else {
            return JsonResult.error("操作失败");
        }
    }

    @GetMapping("/resetpwd")
    //@PreAuthorize("hasPermission('/operator/resetpwd','')")
    @ResponseBody
    public JsonResult resetpwd(@RequestParam("operid") String operid) {
        if (operatorService.resetPwd(operid)) {
            return JsonResult.ok("操作成功，密码重置为123456");
        } else {
            return JsonResult.error("操作失败");
        }
    }

    @PostMapping("/updatestate")
    //@PreAuthorize("hasPermission('/operator/updatestate','')")
    @ResponseBody
    public JsonResult updatestate(@RequestParam("operid") String operid, @RequestParam("state") String state) {
        if (operatorService.updateState(operid, state)) {
            return JsonResult.ok("操作成功");
        } else {
            return JsonResult.error("操作失败");
        }
    }

    @GetMapping("/logs")
    public String logs() {
        return "system/operator/logs";
    }

    @GetMapping("/logslist")
    //@PreAuthorize("hasPermission('/operator/logslist','')")
    @ResponseBody
    public PageResult<TOperLog> logslist(@RequestParam("page") Integer pageNo,
                                         @RequestParam("limit") Integer pageSize,
                                         @RequestParam(value = "searchkey", required = false) String searchKey) {
        try {
            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
            LogBean searchBean = new LogBean();
            searchBean.setPageNo(pageNo);
            searchBean.setOpername(searchKey);
            searchBean.setPageSize(pageSize);
            return operatorService.getOperLogs(searchBean);
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }

    @GetMapping("/userinfor")
    public String userinfor(ModelMap map) {
        TOperator operator = OperUtil.getCurrentOper();
        if(operator!=null){
            operator = operatorService.getOperatorByCode(operator.getOpercode());
        }
        map.put("user", operator);
        return "system/operator/userinfor";
    }

    @PostMapping("/updateinfor")
    @ResponseBody
    public JsonResult updateinfor(@RequestBody TOperator oper) {
        TOperator operator = OperUtil.getCurrentOper();
        if (oper != null) {
            operator.setSex(oper.getSex());
            operator.setOpername(oper.getOpername());
            operator.setEmail(oper.getEmail());
            operator.setMobile(oper.getMobile());
            operatorService.saveOperator(operator);
        }
        return JsonResult.ok("操作成功");
    }

    @GetMapping("/setpwd")
    public String setpwd(ModelMap map) {
        return "system/operator/setpwd";
    }

    @PostMapping("/dosetpwd")
    @ResponseBody
    public JsonResult dosetpwd(@RequestParam String curpwd,
                               @RequestParam String newpwd, @RequestParam String renewpwd) {
        if (StringUtil.isEmpty(curpwd)
                || StringUtil.isEmpty(newpwd)
                || StringUtil.isEmpty(renewpwd)) {
            return JsonResult.error("参数粗错误");
        }
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        String encpwd = encoder.encode(curpwd);
        TOperator operator = OperUtil.getCurrentOper();
        if (operator == null) {
            return JsonResult.error(401, "登录已过期，请重新登录");
        }
        if (!encoder.matches(curpwd,operator.getPassword())) {
            return JsonResult.error("当前密码错误");
        }
        if (!newpwd.equals(renewpwd)) {
            return JsonResult.error("两次密码不一致");
        }
        if(newpwd.length()<6||newpwd.length()>20){
            return JsonResult.error("密码6~20个字符");
        }
        operator.setOperpwd(encoder.encode(newpwd));
        operatorService.saveOperator(operator);
        return JsonResult.ok("密码修改成功，请重新登录");
    }

    @Autowired
    ManagerService managerService;
    @Autowired
    SystemService systemService;


    @RequestMapping("/operatorindex")
    public String operatorindex(){
        return "system/operator";
    }

    /**
     * 根据查询条件分页获取管理员列表
     * @param request
     * @param response
     * @param pageNo
     * @param pageSize
     * @param operid
     * @param realname
     * @param operUser
     * @return
     */
    @RequestMapping("/loadOperatorList")
    @ResponseBody
    public Map loadRegionList(HttpServletRequest request,
                              HttpServletResponse response,
                              @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                              @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
                              @RequestParam(value = "operid", required = false, defaultValue = "") String operid,
                              @RequestParam(value = "realname", required = false, defaultValue = "") String realname,
                              @AuthenticationPrincipal TOperator operUser){
        Map map = new HashMap();
        try{
            Pagination page = null;
            String opertype = operUser.getOpertype();
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))){
                page = managerService.getOperatorList(operid, realname, pageNo, pageSize);
                map.put("PageResult", page);
            }else {
                page = managerService.getOperOperatorList(operUser.getOperid(), operid, realname, pageNo, pageSize);
                map.put("PageResult", page);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return map;
    }

    /**
     * 删除注销管理员
     * @param operid
     * @param request
     * @param response
     * @return
     */
    @RequestMapping("/deleteOperator")
    @ResponseBody
    public Map deleteOperator(@RequestParam(value = "operid") String operid,
                            HttpServletRequest request, HttpServletResponse response){
        Map map = new HashMap();
        String message="";
        try{
            boolean flag = managerService.deleteOperatorById(operid);
            if (flag==false){
                message="删除操作员失败!";
            }

        }catch (Exception e){
            e.printStackTrace();
            message="删除操作员出错!";
        }
        map.put("message", message);
        return map;
    }

    /**
     * 获取管理员填充数据
     * @param operid
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping("/loadOperatorForUpdate")
    public Map loadOperatorForUpdate(@RequestParam(value = "operid") String operid,
                                   @AuthenticationPrincipal TOperator operUser){
        Map map = new HashMap();
        try {
            TOperator operator = managerService.getOperatorById(operid);
            map.put("operator",operator);
            if (operator!=null){
                TRole operRole = managerService.getOperRoleById(operid);
                map.put("operatorroleid", operRole.getRoleId());
            }
            List<TDictionaryId> opertypes = systemService.findOpertypes(operUser.getOpertype());
            map.put("opertypes", opertypes);
            List<TRole> roles = null;
            if (!StringUtil.isEmpty(operUser.getOpertype()) && (operUser.getOpertype().equals("P") || operUser.getOpertype().equals("S"))) {
                 roles = roleService.findAllRoles();
            }else {
                roles = roleService.findAllRolesByOperid(operUser.getOperid());
            }
            map.put("roles", roles);

            List<TRegion> regions = null;
            if (!StringUtil.isEmpty(operUser.getOpertype()) && (operUser.getOpertype().equals("P") || operUser.getOpertype().equals("S"))) {
                regions = systemService.getAllRegions();
                map.put("regions", regions);
            }else if (!StringUtil.isEmpty(operUser.getRegionid())){
                regions = systemService.getRegionListById(operUser.getRegionid());
                map.put("regions", regions);
            }

            List<TCompany> companys = null;
            companys = companyService.getValidCompanyList();
            map.put("companys", companys);

        }catch (Exception e){
            e.printStackTrace();
        }
        return map;
    }

    /**
     * 保存操作员
     * @param postData
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/addOperator", method = {RequestMethod.POST})
    public Map addOperator (@RequestBody OperatorBean postData,@AuthenticationPrincipal TOperator operUser){
        Map map = new HashMap();
        try{
            TOperator operatorById = managerService.getOperatorById(postData.getOperid());
            if (operatorById!=null){
                map.put("errStr", "操作员编号已经存在，请修改！");
                return map;
            }
            TOperator operatorByOpercode = managerService.getOperatorByOpercode(postData.getOpercode());
            if (operatorByOpercode!=null){
                map.put("errStr", "登录名已经存在，请修改！");
                return map;
            }

            TOperator operator = new TOperator();
            operator.setOperid(postData.getOperid());
            operator.setOpername(postData.getOpername());
            operator.setOpercode(postData.getOpercode());
            operator.setOpertype(postData.getOpertype());
            BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
            operator.setOperpwd(encoder.encode(WebConstant.OPERPWD_DEFAULT));
            operator.setStatus(TradeDict.STATUS_NORMAL);
            operator.setEmail(postData.getEmail());
            operator.setMobile(postData.getMobile());
            operator.setOpendate(DateUtil.getNow("yyyyMMdd"));
            operator.setRealname(postData.getRealname());
            operator.setFoperid(operUser.getOperid());
            operator.setRegionid(postData.getRegionid());
            operator.setCompanyId(postData.getCompanyId());

            managerService.saveOperator(operator);

            TOperRole operRole = new TOperRole();
            operRole.setOperid(postData.getOperid());
            operRole.setRoleId(postData.getRoleid());
            managerService.saveOperRole(operRole);
            map.put("errStr", "");
        }catch (Exception e){
            e.printStackTrace();
            map.put("errStr", "保存操作员失败!");
        }
        return map;
    }

    /**
     * 修改操作员
     * @param postData
     * @param operUser
     * @return
     */
    @RequestMapping(value = "/updateOperator", method = {RequestMethod.POST})
    @ResponseBody
    public Map updateOperator(@RequestBody OperatorBean postData,@AuthenticationPrincipal TOperator operUser){
        Map map = new HashMap();
        try {
            if (postData == null) {
                map.put("errStr", "请先选择操作员，然后再修改！");
                return map;
            }

            TOperator operator = managerService.getOperatorById(postData.getOperid());
            operator.setOpername(postData.getOpername());
            operator.setOpercode(postData.getOpercode());
            operator.setOpertype(postData.getOpertype());
            operator.setEmail(postData.getEmail());
            operator.setMobile(postData.getMobile());
            operator.setOpendate(DateUtil.getNow("yyyyMMdd"));
            operator.setStatus("normal");
            operator.setRealname(postData.getRealname());
            operator.setFoperid(operUser.getOperid());
            operator.setRegionid(postData.getRegionid());
            operator.setCompanyId(postData.getCompanyId());

            TOperRole operRole = managerService.getTOperRoleByOperid(postData.getOperid());
            operRole.setRoleId(postData.getRoleid());

            managerService.updateOperator(operator);
            managerService.updateTOperRole(operRole);
            map.put("errStr", "");
        }catch (Exception e){
            e.printStackTrace();
            map.put("errStr", "操作员修改失败!");
        }
        return map;
    }

}
