package com.supwisdom.dlpay.system.dao.impl;

import com.supwisdom.dlpay.framework.domain.TOperRole;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.domain.TRole;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.system.bean.OperatorListBean;
import com.supwisdom.dlpay.system.dao.ManagerDao;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.List;

@Repository
public class ManagerDaoImpl implements ManagerDao {

    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public Pagination getOperatorList(String operid, String realname, int pageNo, int pageSize) {
        String sql = "select a.operid,a.opername,a.opercode,case when a.opertype='P' then '超级管理员' when a.opertype='S' then '系统管理员' " +
                " when a.opertype='H' then '区域管理员' when a.opertype='L' then '楼栋管理员' else a.opertype end opertype," +
                "a.realname,case when a.status='normal' then '有效' else '注销' end status,a.regionid,a.mobile,a.email,a.foperid,c.roleid,c.rolename,d.regionname,a.companyId,e.companyName " +
                " from Tb_Operator a " +
                " left join tb_oper_role b on a.operid = b.operid " +
                " left join tb_role c on b.roleid = c.roleid " +
                " left join tb_region d on a.regionid = d.regionid " +
                " left join tb_company e on a.companyid = e.companyid " +
                " where 1>0  ";
        if (!StringUtil.isEmpty(operid)){
            sql += " and a.operid = :operid ";
        }

        if (!StringUtil.isEmpty(realname)){
            sql += " and a.realname like :realname ";
        }

        sql += " order by a.operid";
        Query query = entityManager.createNativeQuery(sql, OperatorListBean.class);

        if (!StringUtil.isEmpty(operid)){
            query.setParameter("operid", operid);
        }

        if (!StringUtil.isEmpty(realname)){
            query.setParameter("realname", "%"+realname+"%");
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<OperatorListBean> list = query.getResultList();
        page.setList(list);
        int totalCount = getOperatorListCount(operid, realname);
        page.setTotalCount(totalCount);
        return page;
    }


    private int getOperatorListCount(String operid, String realname){
        String sql = "select count(*) from tb_operator a " +
                " left join tb_oper_role b on a.operid = b.operid " +
                " left join tb_role c on b.roleid = c.roleid " +
                " left join tb_region d on a.regionid = d.regionid " +
                " left join tb_company e on a.companyid = e.companyid " +
                "where 1>0 ";

        if (!StringUtil.isEmpty(operid)){
            sql += " and a.operid = :operid ";
        }

        if (!StringUtil.isEmpty(realname)){
            sql += " and a.realname like :realname ";
        }

        Query query = entityManager.createNativeQuery(sql);
        if (!StringUtil.isEmpty(operid)){
            query.setParameter("operid", operid);
        }

        if (!StringUtil.isEmpty(realname)){
            query.setParameter("realname", "%"+realname+"%");
        }
        int cnt=0;
        List list = query.getResultList();
        if (list!=null && list.size()>0){
            cnt = Integer.parseInt(list.get(0).toString());
        }
        return cnt;
    }

    @Transactional
    @Override
    public Pagination getOperOperatorList(String operatorOperid, String operid, String realname, int pageNo, int pageSize) {
        String sql = "select a.operid,a.opername,a.opercode,case when a.opertype='P' then '超级管理员' when a.opertype='S' then '系统管理员' " +
                " when a.opertype='H' then '区域管理员' when a.opertype='L' then '楼栋管理员' else a.opertype end opertype,a.realname,case when a.status='normal' then '有效' else '注销' end status,a.regionid,a.mobile,a.email,a.foperid,c.roleid,c.rolename,d.regionname, " +
                " a.companyid,e.companyName "+
                " from Tb_Operator a " +
                " left join tb_oper_role b on a.operid = b.operid " +
                " left join tb_role c on b.roleid = c.roleid " +
                " left join tb_region d on a.regionid = d.regionid " +
                " left join tb_company e on a.companyid = e.companyid " +
                " where 1>0 and   a.foperid=:operatorOperid ";
        if (!StringUtil.isEmpty(operid)){
            sql += " and a.operid = :operid ";
        }

        if (!StringUtil.isEmpty(realname)){
            sql += " and a.realname like :realname ";
        }

        sql += " order by a.operid";
        Query query = entityManager.createNativeQuery(sql, OperatorListBean.class);
        query.setParameter("operatorOperid" , operatorOperid);
        if (!StringUtil.isEmpty(operid)){
            query.setParameter("operid", operid);
        }

        if (!StringUtil.isEmpty(realname)){
            query.setParameter("realname", "%"+realname+"%");
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<OperatorListBean> list = query.getResultList();
        page.setList(list);
        int totalCount = getOperOperatorListCount(operatorOperid,operid, realname);
        page.setTotalCount(totalCount);
        return page;
    }

    private int getOperOperatorListCount(String operatorOperid, String operid, String realname){
        String sql = "select count(*) from tb_operator a " +
                " left join tb_oper_role b on a.operid = b.operid " +
                " left join tb_role c on b.roleid = c.roleid " +
                " left join tb_region d on a.regionid = d.regionid " +
                " left join tb_company e on a.companyid = e.companyid " +
                "where   a.foperid=:operatorOperid ";

        if (!StringUtil.isEmpty(operid)){
            sql += " and a.operid = :operid ";
        }

        if (!StringUtil.isEmpty(realname)){
            sql += " and a.realname like :realname ";
        }

        Query query = entityManager.createNativeQuery(sql);
        query.setParameter("operatorOperid" , operatorOperid);
        if (!StringUtil.isEmpty(operid)){
            query.setParameter("operid", operid);
        }

        if (!StringUtil.isEmpty(realname)){
            query.setParameter("realname", "%"+realname+"%");
        }
        int cnt=0;
        List list = query.getResultList();
        if (list!=null && list.size()>0){
            cnt = Integer.parseInt(list.get(0).toString());
        }
        return cnt;
    }



    @Transactional
    @Override
    public boolean updateOperatorStatusById(String operid) {
        boolean flag = false;
        try {
            String sql = "update tb_operator set status = 'closed' where operid = ?1";
            Query query = entityManager.createNativeQuery(sql);
            query.setParameter(1, operid);
            query.executeUpdate();
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public TOperator getOperatorById(String operid) {
        String sql = "select bean from TOperator bean where  bean.operid=:operid ";
        TypedQuery<TOperator> query = entityManager.createQuery(sql, TOperator.class);
        query.setParameter("operid", operid);
        List<TOperator> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public TOperator getOperatorByOpercode(String opercode) {
        String sql = "select bean from TOperator bean where  bean.opercode=:opercode ";
        TypedQuery<TOperator> query = entityManager.createQuery(sql, TOperator.class);
        query.setParameter("opercode", opercode);
        List<TOperator> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public TRole getOperRoleById(String operid) {
        String sql = "select a.roleid,a.createtime,a.editflag,a.lastsaved,a.rolecode,a.roledesc,a.rolename,a.operid  " +
                " from Tb_Role a left join tb_oper_role b on a.roleid = b.roleid where b.operid=?1 ";
        Query query = entityManager.createNativeQuery(sql, TRole.class);
        query.setParameter(1, operid);
        List<TRole> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean saveOperator(TOperator bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public boolean updateOperator(TOperator bean) {
        boolean flag=false;
        try {
            entityManager.merge(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public boolean saveOperRole(TOperRole bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public TOperRole getTOperRoleByOperid(String operid) {
        String sql = "select bean from TOperRole bean where bean.operid=:operid";
        TypedQuery<TOperRole> query = entityManager.createQuery(sql, TOperRole.class);
        query.setParameter("operid", operid);
        List<TOperRole> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean updateTOperRole(TOperRole bean) {
        boolean flag=false;
        try {
            entityManager.merge(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }
}
