package com.supwisdom.dlpay.system.service;


import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.system.domain.TCompany;
import com.supwisdom.dlpay.system.domain.TModifyCompany;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface CompanyService {
    //分页获取系统管理员权限公司信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getSystemCompanyList(String companyName,int pageNo,int pageSize);

    //获取用户所属公司信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getOperCompanyList(String companyName,int pageNo,int pageSize,String operid);

    //根据名称获取公司信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TCompany getCompanyByName(String companyName);

    //保存公司信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveCompany(TCompany bean);

    //根据id获取所有状态下的公司信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TCompany getCompanyAllStatusById(String companyId);

    //修改公司信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean updateCompany(TCompany bean);

    //根据公司id获取管理员
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TOperator> getOperByCompanyId(String companyId);

    //根据id和名称获取非本id的相同名称公司
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TCompany getCompanyByNameAndId(String companyName,String companyId);

    //分页获取需要审核的公司信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getCheckCompanyList(String companyName,int pageNo,int pageSize);

    //根据公司id获取需审核的公司
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TCompany getCheckCompanyById(String companyId);

    //获取所有不需要审核且有效的公司
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TCompany> getValidCompanyList();

    //根据公司id获取公司修改表公司信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TModifyCompany getModifyCompanyById(String companyId);

    //保存公司修改表
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveModifyCompany(TModifyCompany bean);

    //根据id和名称获取非本id的相同名称且有效的修改公司
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TModifyCompany getModifyCompanyByNameAndId(String companyName,String companyId);

    //修改修改公司表信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean updateModifyCompany(TModifyCompany bean);
}
