package com.supwisdom.dlpay.system.service;


import com.supwisdom.dlpay.ncmgr.domain.TBuilding;
import com.supwisdom.dlpay.system.bean.AllotBuildingBean;
import com.supwisdom.dlpay.system.bean.RegionZTreeNodes;
import com.supwisdom.dlpay.system.domain.*;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface SystemService {

    //刷新全部字典值
    void refreshCache();

    //刷新管理员属性字典值
    void refreshOpertypesCashe();

    //根据查询条件分页查询字典
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination findDictionary(String dicttype, String dictcaption, Integer pageNo, Integer pageSize);

    //获取所有字典类型
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<DictionaryType> findDictionaryType();

    //保存字典值
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveDictionary(String dicttype, String dicttypename, String dictval, String dictcaption);

    //根据类型获取字典值
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TDictionaryId> findTDictionaryByType(int type);

    //根据管理员属性获取其能分配的管理员属性 sql中字典type固定为1
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TDictionaryId> findOpertypes(String opertype);

    //根据类型和值获取字典值
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TDictionaryId> findByType(int type, String dicVal);

    //修改字典值
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TDictionary updateDictionary(String dicttype, String dicttypename, String dictval, String dictcaption, String oriengaltype, String oriengalval);


    /*systemParam参数*/

    //根据参数key获取参数value
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TSystemParam getSystemParamByKey(String paramKey);

    //根据参数key修改参数value
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean updateSystemParamValueByKey(String paramKey,String paramValue);

    //保存systemParam参数
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveSystemParam(TSystemParam bean);


    //根据查询条件分页获取所有区域
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getSystemRegionList(String regionname,int pageNo,int pageSize);

    //根据查询条件以及管理员区域分页获取区域
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getOperatorRegionList(String regionname,String regionid,int pageNo,int pageSize);

    //根据区域id查询楼栋
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TBuilding> getBuildingByRegionId(String regionid);

    //根据区域id查询区域管理员权限下楼栋
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TBuilding> getOperatorBuildingByRegionId(String regionid,String operRegionid);

    //根据区域id查询楼栋管理员权限下楼栋
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TBuilding> getBuildingOperBuildingByRegionId(String regionid,String operid);

    //根据id删除区域--修改状态flag为0
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean deleteRegionById(String regionid);

    //根据id获取区域
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TRegion getRegionById(String regionid);

    //根据id获取所有状态的区域---查重使用
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TRegion getRegionAllFlagById(String regionid);

    //根据区域id获取其权限下所有区域
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TRegion> getRegionListById(String regionid);

    //根据区域id获取其下级所有区域
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TRegion> getLowRegionListById(String regionid);

    //根据区域级别获取其上一级级别的所有区域
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TRegion> getRegionListByLevel(int level);

    //根据区域级别获取其权限下上一级级别的区域
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TRegion> getOperRegionListByLevel(int level,String regionid);

    //获取所有区域
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TRegion> getAllRegions();

    //根据名称获取区域
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TRegion getRegionByName(String regionname);

    //保存区域
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveRegion(TRegion bean);

    //根据id和名称获取非本id的相同名称区域
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TRegion getRegionByNameAndId(String regionname,String regionid);

    //修改区域
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean updateRegion(TRegion bean);

    //根据区域id修改其子区域的父区域名
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean updateParentnameById(String regionid,String parentname);

    //获取区域树形数据
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<RegionZTreeNodes> getAllRegionTreeList();


    //根据查询条件分页获取所有楼栋
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getSystemBuildingList(String regionid,String buildingname,int pageNo,int pageSize);

    //根据查询条件分页获取区域管理员权限下所有楼栋
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getOperatorBuildingList(String operRegionid,String regionid,String buildingname,int pageNo,int pageSize);

    //分页获取楼栋管理员权限内楼栋
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getBuildingOperBuildingList(String regionid,String buildingname,String operid,int pageNo,int pageSize);

    //根据id获取楼栋信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TBuilding getBuildingById(String buildingid);

    //根据名称获取楼栋信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TBuilding getBuildingByName(String buildingname);

    //保存楼栋
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveBuilding(TBuilding bean);

    //根据id和名称获取非本id的相同名称楼栋
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TBuilding getBuildingByNameAndId(String buildingname,String buildingid);

    //修改楼栋
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean updateBuilding(TBuilding bean);

    //根据id删除楼栋---修改flag为D
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean delBuilding(String buildingid);

    //获取所有要分配的楼栋
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<AllotBuildingBean> findSystemAllotBuildingList();

    //获取操作员权限下要分配的楼栋
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<AllotBuildingBean> findOperatorAllotBuildingList(String operRegionid);

    //获取已经分配过的楼栋
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<AllotBuildingBean> findBuildingInOper(String operid);

    //根据操作员id删除所有分配的楼栋
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean deleteOperBuildingByOperid(String operid);

    //保存操作员分配的楼栋
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveOperBuilding(TOperbuilding bean);

    //获取所有楼栋信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TBuilding> getAllBuildings();

    //获取区域管理员权限下的所有楼栋信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TBuilding> getOperatorBuildings(String regionid);

    //获取楼栋管理员权限下的楼栋
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TBuilding> getBuildingOperBuildings(String operid);
}
