var app = {

    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },

    onDeviceReady: function() {
        this.loadBill()
    },
    toBack: function (){
        //window.history.back();
        window.history.go(-1)
    },
    loadBill: function() {
        var refno = window.localStorage.getItem("currentrefno");
        if (isEmpty(refno)) {
            $.alert("加载失败了", "提示");
            return;
        }
        $.showLoading("加载中");
        var param = {
            "billid": refno
        }
        V1Billdetail(param, function(ok, ret) {
            if (ok) {
                if (ret.code == 200) {
                    if (ret.dtl == null) {
                        $.hideLoading();
                        $.alert("数据加载异常，请稍后再试", "错误");
                    } else {
                        app.initBillView(ret.dtl)
                    }
                } else {
                    $.hideLoading();
                    $.alert("数据加载异常，请稍后再试", "错误");
                }
            } else {
                $.hideLoading();
                $.alert("请求失败了:" + ret.status + "请稍后再试", "错误");
            }
        })
    },
    initBillView: function(data) {
        console.log(data);
        if (data.tradeflag == 'in') {
            $("#amount").text('+' + data.amount)
        } else {
            $("#amount").text(data.amount)
        }
        if (data.status == 'success') {
            $("#status").text("交易成功");
        } else {
            $("#status").text("交易失败");
        }
        $("#tranddes").text(data.transdesc);
        $("#transtime").text(formatDate(data.transdate + '' + data.transtime, true));
        $("#refno").text(data.refno);
        $.hideLoading();
    }
};
app.initialize();