var dict;
var app = {

    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },

    onDeviceReady: function() {
        var uid = window.localStorage.getItem("uid");
        this.loadData();
    },
    loadData: function() {
        $.showLoading("正在加载");
        V1Idtypes(function(ok, ret) {
            if (ok) {
                $.hideLoading();
                if (ret.code == 200) {
                    dict = ret.idtypes;
                    let keys = Object.keys(dict);
                    let vals = Object.values(dict);
                    console.log(keys, vals)
                    var items=[];
                    var selectItem=items[0];
                    for(var key of keys){
                        var bean = {
                            "title":dict[key],
                            "value":key
                        }
                        if(key == 'idcard'){
                            selectItem=bean;
                        }
                        items.push(bean)
                    }
                    $("#idtype").val(selectItem.title)
                    $("#idtype").attr("data-values",selectItem.value)
                    $("#idtype").select({
                      title: "请选择证件类型",
                      items: items
                    });
                } else {
                    $.alert(ret.msg, "错误");
                }
            } else {
                $.hideLoading();
                $.alert("请求失败了 " + ret.status + "，请稍后再试", "错误");
            }
        })
    },
    doNext: function() {
        var cardnum = $("#cardnum").val();
        var name = $("#name").val();
        var idno = $("#idno").val();
        if (isEmpty(name) || isEmpty(cardnum)||isEmpty(idno)) {
            return;
        }
        var idtype = $("#idtype").attr("data-values")
        if(isEmpty(idtype)){
            $.alert("请选择证件类型", "错误");
            return;
        }
        cardnum = cardnum.trim();
        name = name.trim();
        idno = idno.trim();
        
        $.showLoading("正在处理");
        var param = {
            "cardno": cardnum,
            "idtype": idtype,
            "name": name,
            "idno": idno
        }
        V1Bindcard(param, function(ok, ret) {
            if (ok) {
                $.hideLoading();
                console.log(ret)
                if (ret.code == 200) {
                    window.localStorage.setItem("name", name);
                    window.localStorage.setItem("cardno", cardnum);
                    window.localStorage.setItem("idtype", idtype);
                    window.localStorage.setItem("idno", idno);
                    window.localStorage.setItem("phoneX",ret.phonex);
                    window.localStorage.setItem("personid", ret.personid);
                    window.localStorage.setItem("userid", ret.personid);
                    window.localStorage.setItem("signed", ret.signed);
                    window.localStorage.setItem("paypwdset", ret.paypwdset);
                    if(ret.signed=='yes'){
                        window.location = "main.html"
                    }else{
                        window.location = "bindcheck.html";
                    }
                    
                } else {
                    if (ret.code == -1) {
                        $.alert(ret.msg, "提示", function() {
                            window.location = "main.html"
                        });
                    } else {
                        $.alert(ret.msg, "错误");
                    }
                }
            } else {
                $.hideLoading();
                $.alert("请求失败了 " + ret.status + "，请稍后再试", "错误");
            }
        })
    }
};
app.initialize();