var app = {

    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },
  
    onDeviceReady: function() {
        this.receivedEvent('deviceready');
        this.loginWithFinger();
    },
    loginWithFinger:function(){
        let loginfinger =  window.localStorage.getItem("loginfinger");
        let phone =  window.localStorage.getItem("phone");
        let pwd =  window.localStorage.getItem("localpwd");
        let _this = this;
        if(phone&&pwd&&loginfinger&&loginfinger=='1'){
              Fingerprint.isAvailable(function(result){
                 Fingerprint.show({
                       title:"正在使用指纹或人脸登录",
                       description: "请验证您的指纹或人脸"
                     }, function(success){
                        _this.loginIt(phone,pwd);
                     }, function(error){
                       $.alert("验证失败，指纹或人脸错误，请使用密码登录", "提示");
                       //$("#login").removeAttr("checked");
                     });

             }, function(message){
                  $.alert("设备不支持指纹或人脸，请使用密码登录", "提示");
             });
        }
    },

    // Update DOM on a Received Event
    receivedEvent: function(id) {
        var phone =  window.localStorage.getItem("phone");
        if(!isEmpty(phone)){
            $("#phone").val(phone)
        }
    },
    toRegister :function(){
        window.location = "register.html";
    },
    toForget :function(){
        window.location = "findpwd.html";
    },
    login: function(){
        //loading("正在处理");
        var phone = $("#phone").val()
        var pwd = $("#pwd").val()
        if(isEmpty(phone)||isEmpty(pwd)){
            return;
        }
        this.loginIt(phone,pwd);
    },
    loginIt: function(phone,pwd){
        $.showLoading("登录中");
        var param={
            "username":phone,
            "password":pwd,
            "platform":device.platform
        }
        Login(param,function(ok,ret){
            console.log(ret)
            if(ok){
               if(ret.code!=200){
                 $.alert(ret.msg, "错误");
                 //closeLoading('loginBtn')
                 //showOk(ret.msg)
                 $.hideLoading();
               }else{
                 window.localStorage.setItem("phone",phone); 
                 window.localStorage.setItem("phoneX",ret.phone);
                 window.localStorage.setItem("token",ret.token); 
                 window.localStorage.setItem("uid",ret.uid); 
                 window.localStorage.setItem("tenantid",ret.tenantid); 
                 window.localStorage.setItem("tokenexpire",ret.expire); 
                 window.localStorage.setItem("tokentime",ret.now); 
                 window.localStorage.setItem("userid",ret.userid);
                 window.localStorage.setItem("signed",ret.signed); 
                 window.localStorage.setItem("paypwdset",ret.paypwdset); 
                 window.localStorage.setItem("name",ret.name);  
                 window.localStorage.setItem("localpwd",pwd);  
                 window.location = "main.html";  
               }     
            }else{
               //$.alert("请求失败了"+ret.status+"，请稍后再试", "错误");
               //closeLoading('loginBtn')
               //showOk("请求失败了"+ret.status+"，请稍后再试")
               $.alert("请求失败了"+ret.status+"，请稍后再试", "错误");
               $.hideLoading();
            }
        })
    }
};
app.initialize();
