var app = {

    // Application Constructor
    initialize: function() {
        this.initTab();
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
        document.addEventListener('jpush.receiveRegistrationId', function(event) {
             console.log(event.registrationId)
        }, false)
        document.addEventListener("jpush.openNotification", function (event) {
          var refno
          console.log("openNotify:"+event);
          if(device.platform == "Android") {
            refno = event.extras.refno
          } else {
            refno = event.refno
            window.JPush.setApplicationIconBadgeNumber(0);
          }
          app.openBill(refno);
          console.log("openNotify:"+refno);
        }, false)
    },
    openBill:function(billno){
        window.localStorage.setItem("currentrefno",billno);
        window.location='billdetail.html';
    },
    initJpush: function() {
        if(device.platform == "Android") {
        } else {
         window.JPush.setApplicationIconBadgeNumber(0);
        }
        window.JPush.init();
        window.JPush.setDebugMode(true);
        window.JPush.isPushStopped(function(result) {
            if (result == 0) {
                //window.JPush.resumePush();
            } else {
                window.JPush.resumePush();
            }
        });
        window.JPush.getUserNotificationSettings(function(result) {
          if(result == 0) {
          } else if(result > 0) {
          }
         });
        var uid = window.localStorage.getItem("uid");

        window.JPush.setAlias({ sequence: 1, alias: uid },
          (result) => {
            var sequence = result.sequence
            var alias = result.alias
            //alert(JSON.stringify(result))
          }, (error) => {
            var sequence = error.sequence
            var errorCode = error.code
            //alert(JSON.stringify(error))
          })
    },

    onDeviceReady: function() {
        var uid = window.localStorage.getItem("token");
        this.initJpush();
        $('#scanBtn').click(function() {
            //window.location = "scan.html";
            app.checkBefore(function() {
                app.checkOther(function() {
                    window.location = "scan.html";
                })
            })
        });
        $('#qrcodeBtn').click(function() {
            app.checkBefore(function() {
                app.checkOther(function() {
                    window.location = "qrcode.html";
                })
            })
        });
        $('#cardBtn').click(function() {
            app.checkBefore(function() {
                app.checkOther(function() {
                    window.location = "card.html";
                })
            })
        });
        $('#billBtn').click(function() {
            app.checkBefore(function() {
                window.location = "bill.html";
            })
        });
        $('#moreBtn').click(function() {
            app.checkBefore(function() {
                window.location = "bill.html";
            })
        });
        $('#secBtn').click(function() {
            //window.location = "security.html";
            app.checkBefore(function() {
                app.checkOther(function() {
                    window.location = "security.html";
                })
            })
        });
        $("#doorBtn").click(function(){
            app.checkBefore(function() {
                showRet(DOOR_URl);
            })
        })
        $('#usersec').click(function() {
            app.checkBefore(function() {
                app.checkOther(function() {
                    window.location = "security.html";
                })
            })
        });
        $('#accsignbtn').click(function() {
            app.checkBefore(function() {
                var signed = window.localStorage.getItem("signed");
                var cum = new auiDialog({});
                 if (isEmpty(signed) || signed != 'yes') {
                    var confirm = cum.alert({
                        title: "提示",
                        msg: '您尚未签约市民卡免密代扣签约协议，无法使用该功能',
                        buttons: ['取消', '去签约']
                    }, function(ret) {
                        if (ret.buttonIndex == 2) {
                           app.toSignCode();
                        }
                    })
                }else{
                    window.location = 'signxycheck.html'
                }
            })
        });
        this.initData();
        this.backBtn();
    },
    backBtn: function(){
        document.addEventListener("backbutton", function(e){
               e.preventDefault();
               navigator.app.exitApp();
            }, false);
    },
    initTab: function() {
        $("#maincontent").css("top", $("#maintop").height())
        var tab = new auiTab({
            element: document.getElementById("footer"),
        }, function(ret) {
            window.localStorage.setItem("tabindex", ret.index);

            changeTab(ret.index);
        });
        var tabindex = window.localStorage.getItem("tabindex");
        if (!tabindex || tabindex == 0) {
            tabindex = 1
        }
        changeTab(tabindex);
        tab.setActive(tabindex)

        function changeTab(index) {
            if (index == 1) {
                $("#main1").show();
                $("#main2").hide();
            } else if (index == 2) {
                $("#main1").hide();
                $("#main2").show();
            }
        }
    },
    initData: function() {
        this.loadBill()
    },
    loadBill: function() {
        $("#loaddata").show()
        $("#nodata").hide();
        var param = {
            "pageno": 1,
            "platform":device.platform
        }
        V1Bills(param, function(ok, ret) {
            if (ok) {
                console.log(ret)
                if (ret.code == 200) {
                    app.checkVersion(ret.version,ret.minversion,ret.versionmsg,ret.versionurl);
                    //app.checkVersion("1.3.9","1","new func","https://shouji.baidu.com/software/26706357.html");
                    $("#maingt").text(ret.t + "！")
                    $("#user-amount").text(ret.amount)
                    $("#user-point").text(ret.point)
                    if (ret.needrebind) {
                        window.localStorage.removeItem("userid");
                    } else {
                        window.localStorage.setItem("userid", ret.userid);
                    }
                    window.localStorage.setItem("signed", ret.signed);
                    window.localStorage.setItem("paypwdset", ret.paypwdset);
                    window.localStorage.setItem("name", ret.name);
                    if (ret.page && ret.page.count > 0) {
                        GLOBAL_TODAY = ret.today;
                        GLOBAL_YESTERDAY = ret.yesterday;
                        app.initBillView(ret.page)
                        app.initView();
                    } else {
                        $("#loaddata").hide()
                        $("#nodatahint").text("暂无数据")
                        $("#nodata").show();
                        app.initView();
                    }
                } else {
                    $("#loaddata").hide()
                    $("#nodatahint").text("数据加载异常")
                    $("#nodata").show();
                    app.initView();
                }
            } else {
                $("#loaddata").hide()
                $("#nodatahint").text("请求数据失败")
                $("#nodata").show();
                app.initView();
            }
        })
    },
    checkVersion:function(ver,minver,m,url){
        cordova.getAppVersion.getVersionNumber(function (version) {
            //alert(version);
            //alert(version);
            if(ver>version){
                var cum = new auiDialog({});
                var confirm = cum.alert({
                    title: "有新的版本",
                    msg: m,
                    buttons: ['取消', '去更新']
                }, function(ret) {
                    if (ret.buttonIndex == 2) {
                       cordova.InAppBrowser.open(url, '_system', 'location=no,toolbar=yes,toolbarposition=top,closebuttoncaption=关闭');
                    }
                })  
            }
        });
    },
    initBillView: function(page) {
        var html = '';
        for (var i = 0; i < page.data.length; i++) {
            var bean = page.data[i]
            html += '<div class="aui-card-list-header aui-card-list-user" onclick="app.toBillDetail(\'' + bean.refno + '\')">';
            html += '<div class="aui-card-list-user-avatar"><img src="img/icon_meal.png" class="aui-margin-r-10 aui-img-round" />';
            html += '</div><div class="aui-card-list-user-name">';
            html += '<div>' + bean.transdesc + '</div>';
            if (bean.tradeflag == 'in') {
                html += '<div class="aui-list-item-right">+' + bean.amount + '</div>';
            } else {
                html += '<div class="aui-list-item-right">' + bean.amount + '</div>';
            }
            html += '</div><div class="aui-card-list-user-info">' + formatDateNoYear(bean.transdate, bean.transtime) + '</div></div>';
        }
        $("#billcontent").html(html);
        $("#loaddata").hide()
        $("#nodata").hide();
        $("#billcontent").show();

    },
    initView: function() {
        var userid = window.localStorage.getItem("userid");
        var signed = window.localStorage.getItem("signed");
        if (isEmpty(userid)) {
            $("#userbank").text("未绑定");
            $("#userbank").css("color", "red")
        } else {
            $("#userbank").text("已绑定");
            $("userbank").css("color", "#757575");
        }
        if (isEmpty(signed) || signed != 'yes') {
            $("#usersign").text("未签约");
            $("#usersign").css("color", "red")
        } else {
            $("#usersign").text("已签约");
            $("usersign").css("color", "#757575");
        }
        var phone = window.localStorage.getItem("phoneX");
        if (!isEmpty(phone)) {
            $("#userphone").text(phone)
        }
        var name = window.localStorage.getItem("name");
        if (isEmpty(name)) {
            $("#username").text("匿名")
        } else {
            $("#username").text(name)
            $("#homename").text(name)
        }
    },
    checkBefore: function(callback) {
        var uid = window.localStorage.getItem("token");
        if (isEmpty(uid)) {
            window.location = "login.html";
        } else {
            var userid = window.localStorage.getItem("userid");
            if (isEmpty(userid)) {
                var cum = new auiDialog({});
                var confirm = cum.alert({
                    title: "提示",
                    msg: '为了不影响您正常使用相关功能，请先绑定银行卡',
                    buttons: ['取消', '去绑卡']
                }, function(ret) {
                    if (ret.buttonIndex == 2) {
                        window.location = 'bindcard.html'
                    }
                })
            } else {
                if (callback) {
                    callback()
                }
            }
        }
    },
    checkOther: function(callback) {
        var signed = window.localStorage.getItem("signed");
        var cum = new auiDialog({});

        if (isEmpty(signed) || signed != 'yes') {
            var confirm = cum.alert({
                title: "提示",
                msg: '您尚未签约市民卡免密代扣签约协议，无法使用该功能',
                buttons: ['取消', '去签约']
            }, function(ret) {
                if (ret.buttonIndex == 2) {
                   app.toSignCode();
                }
            })
        } else {
            if (callback) {
                callback()
            }
        }
    },
    toSignCode: function(){
        var param = {
        }
        V1Bindcardcode(param, function(ok, ret) {
            if (ok) {
                if (ret.code == 200) {
                    window.location = 'bindcheck.html'
                } else {
                    $.alert(ret.msg, "错误");
                }
            } else {
                $.alert("请求失败了 " + ret.status + "，请稍后再试", "错误");
            }
        })
    },
    toSign: function() {
        window.location = 'signxycheck.html'
    },
    toBillDetail: function(refno) {
        window.localStorage.setItem("currentrefno", refno);
        window.location = 'billdetail.html';
    },
    toCard: function() {
        var userid = window.localStorage.getItem("userid");
        if (isEmpty(userid)) {
            window.location = 'bindcard.html'
        } else {
            window.location = 'cardinfor.html'
        }
    },
    logout:function(){
        window.localStorage.removeItem("token");
        window.location = "login.html";
    }
};
app.initialize();

function showRet(url) {
        if(isEmpty(url)){
            return;
        }
        var userid = window.localStorage.getItem("userid"); 
        //if (url.indexOf("yy.dlsmk.cn")>=0) {
            if(url.indexOf("?")>0){
                url=url+'&userid='+userid;
            }else{
                url=url+'?userid='+userid;
            }
        //}
        console.log(url)
        var inAppBrowserRef = cordova.ThemeableBrowser.open(url, '_blank', {
            statusbar: {
                color: '#03a9f4ff'
            },
            toolbar: {
                height: 44,
                color: '#03a9f4ff'
            },
            title: {
                color: '#ffffffff',
                showPageTitle: true
            },
            backButton: {
                image: 'back.png',
                imagePressed: 'back.png',
                align: 'left',
                event: 'backPressed'
            },
            closeButton: {
                image: 'close.png',
                imagePressed: 'close.png',
                align: 'left',
                event: 'closePressed'
            },
            backButtonCanClose: true
        }).addEventListener('closePressed', function(params){
            inAppBrowserRef.close();
            //window.location = "main.html"
         });
    }
