package com.visionsmarts.pic2shop.view;

import com.visionsmarts.VSReaderQR;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class BarQrCodeUtil {
  public static String qrToString(byte[] qrData) {
    ByteBuffer qrBuffer;
    if (qrData[qrData.length - 1] == 0) {
      qrBuffer = ByteBuffer.wrap(qrData, 0, qrData.length - 1);
    } else {
      qrBuffer = ByteBuffer.wrap(qrData);
    }
    return VSReaderQR.decodeData(qrBuffer, Charset.forName("UTF-8"));
  }

  public static final int DECODE = 100;
  public static final int QUIT = 101;
  public static final int NOTFOUND = 102;

  public static final int BARCODE = 103;
  public static final int QRCODE = 104;

  public static final int AUTO_FOCUS = 105;
}
